/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeneralPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.ListSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theLinkedHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theLinkedHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v4.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v5.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class TeciIO {
    public static final int VERSION_001 = 1;
    public static final int VERSION_002 = 2;
    public static final int VERSION_003 = 3;
    public static final int VERSION_004 = 4;
    public static final int VERSION_005 = 5;
    public static final int VERSION_006 = 6;
    public static final int VERSION_007 = 7;
    public static final int CURR_VERSION = 7;
    private final int d_version;

    public TeciIO(int version) {
        this.d_version = version;
    }

    public Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        if (this.d_version < 2) {
            if (name.equals("thunderheadeng.util.LinkedIdentityHashMap")) {
                return LinkedIdentityHashMap.class;
            }
            if (name.equals("thunderheadeng.util.LinkedIdentityHashSet")) {
                return LinkedIdentityHashSet.class;
            }
            if (name.equals("thunderheadeng.util.ListSet")) {
                return ListSet.class;
            }
            if (name.equals("thunderheadeng.util.theHashMap")) {
                return theHashMap.class;
            }
            if (name.equals("thunderheadeng.util.theHashSet")) {
                return theHashSet.class;
            }
            if (name.equals("thunderheadeng.util.theLinkedHashMap")) {
                return theLinkedHashMap.class;
            }
            if (name.equals("thunderheadeng.util.theLinkedHashSet")) {
                return theLinkedHashSet.class;
            }
        }
        if (this.d_version < 3 && name.equals("thunderheadeng.scene3d.nativebuffered.Image")) {
            return Image.class;
        }
        if (this.d_version < 5 && name.equals("thunderheadeng.geometry.objs.Mesh")) {
            return Mesh.class;
        }
        if (this.d_version < 6 && name.equals("thunderheadeng.geometry.objs.WallGeom")) {
            return WallGeom.class;
        }
        if (name.startsWith("thunderheadeng.") || name.startsWith("[Lthunderheadeng.")) {
            String legName = name;
            legName = legName.replaceFirst("thunderheadeng.", "pyrosim.legacy_2012_1.thunderheadeng.");
            return Class.forName(legName);
        }
        return null;
    }

    public Object resolveObject(Object obj) {
        if (this.d_version < 2) {
            if (obj instanceof LinkedIdentityHashMap) {
                return ((LinkedIdentityHashMap)obj).convert();
            }
            if (obj instanceof theLinkedHashMap) {
                return ((theLinkedHashMap)obj).convert();
            }
            if (obj instanceof theHashMap) {
                return ((theHashMap)obj).convert();
            }
            if (obj instanceof LinkedIdentityHashSet) {
                return ((LinkedIdentityHashSet)obj).convert();
            }
            if (obj instanceof theLinkedHashSet) {
                return ((theLinkedHashSet)obj).convert();
            }
            if (obj instanceof theHashSet) {
                return ((theHashSet)obj).convert();
            }
            if (obj instanceof ListSet) {
                return ((ListSet)obj).convert();
            }
        }
        if (this.d_version < 4 && obj instanceof NGon) {
            return TeciIO.resolvePre4NGon((NGon)obj);
        }
        if (this.d_version < 5 && obj instanceof Mesh) {
            return ((Mesh)obj).fromLegacy();
        }
        if (this.d_version < 6 && obj instanceof WallGeom) {
            return ((WallGeom)obj).fromLegacy();
        }
        if (this.d_version < 7 && obj instanceof Quad) {
            Quad q = (Quad)obj;
            return PolyUtil.newPoly(q.p1, q.p2, q.p3, q.p4);
        }
        return obj;
    }

    private static IPolygon resolvePre4NGon(NGon poly) {
        Point3d[] points = poly.points;
        ArrayList<Integer> loops = new ArrayList<Integer>();
        int ix = 0;
        while (ix < points.length) {
            Point3d next;
            Point3d first = points[ix];
            loops.add(ix++);
            while (ix < points.length && !first.equals(next = points[ix++])) {
            }
        }
        if (loops.size() <= 1) {
            return poly;
        }
        return new GeneralPoly(points, theUtil.toIntArray(loops));
    }
}

