/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v45.domain.measure;

import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.AMeasurement;

public class ObjectMsr
extends AMeasurement {
    static final long serialVersionUID = 1L;
    private int d_id;
    private Object d_obj;

    public int hashCode() {
        return 154139192 + this.d_obj.hashCode() + this.d_id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectMsr)) {
            return false;
        }
        ObjectMsr msr = (ObjectMsr)obj;
        return this.d_id == msr.d_id && this.d_obj.equals(msr.d_obj);
    }

    @Override
    public IQuantity fromLegacy() {
        if (this.d_obj instanceof Particle) {
            Particle part = (Particle)this.d_obj;
            if (part.isMassless()) {
                return null;
            }
            switch (this.d_id) {
                case 0: {
                    return Quantity.PART_ACMPUA.create(part);
                }
                case 1: {
                    return Quantity.PART_CPUA.create(part);
                }
                case 2: {
                    return Quantity.PART_MASS_FLUX_X.create(part);
                }
                case 3: {
                    return Quantity.PART_MASS_FLUX_Y.create(part);
                }
                case 4: {
                    return Quantity.PART_MASS_FLUX_Z.create(part);
                }
                case 5: {
                    return Quantity.PART_MPUA.create(part);
                }
                case 6: {
                    return Quantity.PART_MPUV.create(part);
                }
            }
        } else if (this.d_obj instanceof ExSpec) {
            switch (this.d_id) {
                case 0: {
                    return Quantity.SPEC_MASS_FRACTION.create((ExSpec)this.d_obj);
                }
                case 1: {
                    return Quantity.SPEC_VOLUME_FRACTION.create((ExSpec)this.d_obj);
                }
                case 2: {
                    return Quantity.SPEC_MASS_FLUX_X.create((ExSpec)this.d_obj);
                }
                case 3: {
                    return Quantity.SPEC_MASS_FLUX_Y.create((ExSpec)this.d_obj);
                }
                case 4: {
                    return Quantity.SPEC_MASS_FLUX_Z.create((ExSpec)this.d_obj);
                }
                case 5: {
                    return Quantity.SPEC_MASS_FLUX.create((ExSpec)this.d_obj);
                }
                case 6: {
                    return Quantity.SPEC_DENSITY.create((ExSpec)this.d_obj);
                }
                case 7: {
                    return Quantity.SPEC_VISIBILITY.create((ExSpec)this.d_obj);
                }
                case 8: {
                    return Quantity.SPEC_OPTICAL_DENSITY.create((ExSpec)this.d_obj);
                }
            }
        } else if (this.d_obj instanceof Material) {
            switch (this.d_id) {
                case 0: {
                    return Quantity.MATL_DENSITY.create((Material)this.d_obj);
                }
                case 1: {
                    return Quantity.MATL_SOLID_DENSITY.create((Material)this.d_obj);
                }
            }
        }
        assert (false);
        return null;
    }
}

