/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v31.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.Vector;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.EvacProps;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.IFace;

public abstract class AbstractFDSObject
extends APyroObject
implements FDSObject {
    static final long serialVersionUID = 1L;
    protected String d_name;
    protected Vector<IFace> d_faces;
    protected Color d_color = null;
    protected boolean d_visible = true;
    protected IInPin d_controlPin;
    protected TexOrigin d_texOrigin;
    protected EvacProps d_evac;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_evac == null) {
            this.d_evac = EvacProps.DEFAULT;
        }
    }

    protected Surface[] convertSurfs() {
        Surface[] surfaceArray;
        Surface[] surfs = new Surface[this.d_faces.size()];
        for (int m = 0; m < this.d_faces.size(); ++m) {
            surfs[m] = this.d_faces.get(m).getSurface();
        }
        if (GeomUtil.isUniform(surfs)) {
            Surface[] surfaceArray2 = new Surface[1];
            surfaceArray = surfaceArray2;
            surfaceArray2[0] = surfs[0];
        } else {
            surfaceArray = surfs;
        }
        return surfaceArray;
    }

    protected static int convertOptions(boolean permitHoles, boolean thicken, boolean sawtooth) {
        int options = 0;
        if (permitHoles) {
            options |= 4;
        }
        if (thicken) {
            options |= 1;
        }
        if (!sawtooth) {
            options |= 2;
        }
        return options;
    }

    protected void convertProps(pyrosim.legacy_2012_1.domain.geom.FDSObject obj, int solidOptions) {
        Set<? extends IOutPin> connections = this.d_controlPin.getConnections();
        if (!connections.isEmpty()) {
            obj.getInputPin().connect(connections.iterator().next());
        }
        obj.setEvac(this.d_evac);
        obj.setColors(this.d_color);
        obj.setVisible(this.d_visible);
        obj.setEnabled(this.isEnabled());
        if (obj instanceof IObstruction) {
            ((IObstruction)obj).setOptions(solidOptions, true);
            ((IObstruction)obj).setTextureOrigin(this.d_texOrigin);
        } else if (obj instanceof Vent) {
            ((Vent)obj).setTextureOrigin(this.d_texOrigin);
        }
    }

    @Override
    public IInPin getInputPin() {
        return this.d_controlPin;
    }
}

