/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v26.domain.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;

public abstract class AMeasurementStat
extends APyroObject {
    static final long serialVersionUID = 1L;
    protected IQuantity d_msr;
    protected Set<Grid> d_grids;
    protected Set<Integer> d_stats;

    protected abstract IMeasurementStat newStat(String var1, IQuantity var2, IGeom var3, Collection<Integer> var4);

    public IPyroObject convert() {
        ArrayList<IMeasurementStat> newStats = new ArrayList<IMeasurementStat>(this.d_grids.size());
        boolean appendGridName = this.d_grids.size() > 1;
        Collection<Integer> newRecordStats = AMeasurementStat.convertPre27Stats(this.d_stats);
        for (Grid g : this.d_grids) {
            Object name = this.d_msr.getDescription();
            if (appendGridName) {
                name = (String)name + "_" + g.getName();
            }
            IMeasurementStat newStat = this.newStat((String)name, this.d_msr, new StatGeom.GridGeom(g), newRecordStats);
            newStats.add(newStat);
        }
        if (newStats.size() == 1) {
            return (IPyroObject)newStats.get(0);
        }
        StatisticMgr mgr = new StatisticMgr(this.d_msr.getDescription());
        mgr.addAll(newStats);
        return mgr;
    }

    private static Collection<Integer> convertPre27Stats(Set<Integer> oldStats) {
        ArrayList<Integer> newStats = new ArrayList<Integer>(oldStats.size());
        for (Integer oldStat : oldStats) {
            switch (oldStat) {
                case 0: {
                    newStats.add(65536);
                    break;
                }
                case 1: {
                    newStats.add(131072);
                    break;
                }
                case 2: {
                    newStats.add(262144);
                }
            }
        }
        return newStats;
    }
}

