/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v22.domain.measure;

import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.legacy.v22.domain.measure.Measurement;

public class ObjectMeasurement
extends Measurement {
    static final long serialVersionUID = 1L;
    private int d_id;
    private String d_objType;
    private Object d_obj;

    public int hashCode() {
        return super.hashCode() + this.d_obj.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectMeasurement)) {
            return false;
        }
        ObjectMeasurement objm = (ObjectMeasurement)obj;
        return objm.d_obj.equals(this.d_obj);
    }

    public ObjectQuantity fromLegacy() {
        if (this.d_obj instanceof Particle) {
            Particle part = (Particle)this.d_obj;
            if (part.isMassless()) {
                return null;
            }
            switch (this.d_id) {
                case 0: {
                    return Quantity.PART_ACMPUA.create(part);
                }
                case 1: {
                    return Quantity.PART_CPUA.create(part);
                }
                case 2: {
                    return Quantity.PART_MASS_FLUX_X.create(part);
                }
                case 3: {
                    return Quantity.PART_MASS_FLUX_Y.create(part);
                }
                case 4: {
                    return Quantity.PART_MASS_FLUX_Z.create(part);
                }
                case 5: {
                    return Quantity.PART_MPUA.create(part);
                }
                case 6: {
                    return Quantity.PART_MPUV.create(part);
                }
            }
        } else if (this.d_obj instanceof ExSpec) {
            switch (this.d_id) {
                case 0: {
                    return Quantity.SPEC_MASS_FRACTION.create((ExSpec)this.d_obj);
                }
                case 1: {
                    return Quantity.SPEC_VOLUME_FRACTION.create((ExSpec)this.d_obj);
                }
                case 2: {
                    return Quantity.SPEC_MASS_FLUX_X.create((ExSpec)this.d_obj);
                }
                case 3: {
                    return Quantity.SPEC_MASS_FLUX_Y.create((ExSpec)this.d_obj);
                }
                case 4: {
                    return Quantity.SPEC_MASS_FLUX_Z.create((ExSpec)this.d_obj);
                }
                case 5: {
                    return Quantity.SPEC_MASS_FLUX.create((ExSpec)this.d_obj);
                }
                case 6: {
                    return Quantity.SPEC_DENSITY.create((ExSpec)this.d_obj);
                }
                case 7: {
                    return Quantity.SPEC_VISIBILITY.create((ExSpec)this.d_obj);
                }
                case 8: {
                    return Quantity.SPEC_OPTICAL_DENSITY.create((ExSpec)this.d_obj);
                }
            }
        } else if (this.d_obj instanceof Material) {
            switch (this.d_id) {
                case 0: {
                    return Quantity.MATL_DENSITY.create((Material)this.d_obj);
                }
                case 1: {
                    return Quantity.MATL_SOLID_DENSITY.create((Material)this.d_obj);
                }
            }
        }
        assert (false);
        return null;
    }
}

