/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridMergeUtil;
import pyrosim.legacy_2012_1.domain.GridUtil;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FireSpread;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.tasks.AddGridBoundaryVentsTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class VentParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;
    private final ExSpecParser d_specParser;
    private Map<FDSParseRecord, Vent> d_ventMap;
    private Map<Grid, GridMergeUtil.BoundaryInfo> d_gridFaces;

    public VentParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns, ExSpecParser specParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_specParser = specParser;
        this.d_ventMap = new HashMap<FDSParseRecord, Vent>();
        this.d_gridFaces = null;
    }

    public Map<FDSParseRecord, Vent> getVentMap() {
        return this.d_ventMap;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("VENT");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String surfName = (String)rec.get("SURF_ID", false);
        Surface surf = this.getSurfaceSafe(rec, surfName, Vent.getSurfaceFilter());
        this.d_ventMap.put(rec, null);
        String name = (String)rec.get("ID");
        if (name == null) {
            name = this.generateName(rec, Intl.intl("Vent"));
        }
        if (rec.contains("XB")) {
            UnitPoint3D[] xb = VentParser.parseXB(rec, "VENT", "XB", true);
            if (VentParser.countDimensions(xb[0], xb[1]) > 2) {
                throw new FDSRecordFormatException(rec, Intl.intl("Vents must be specified as two-dimensional objects."));
            }
            Vent vent = new Vent(name, surf, AARectangle.construct(xb[0].getPoint3dValue(Geometry.LU), xb[1].getPoint3dValue(Geometry.LU)));
            if (rec.contains("IOR")) {
                vent.setNormal(pyrosim.legacy_2012_1.io.fds.v5.common.GeomUtil.toWorldVec(rec.getInteger("IOR", false)));
            }
            this.addVent(rec, vent);
            this.addObject(vent);
        } else if (rec.contains("PBX")) {
            double xPlane = rec.getUnitDouble("PBX", false).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(1.0, 0.0, 0.0, -xPlane);
            this.addVentsAlongPlane(rec, name, surf, plane);
        } else if (rec.contains("PBY")) {
            double yPlane = rec.getUnitDouble("PBY", false).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(0.0, 1.0, 0.0, -yPlane);
            this.addVentsAlongPlane(rec, name, surf, plane);
        } else if (rec.contains("PBZ")) {
            double zPlane = rec.getUnitDouble("PBZ", false).getValue(Geometry.LU);
            Plane3d plane = new Plane3d(0.0, 0.0, 1.0, -zPlane);
            this.addVentsAlongPlane(rec, name, surf, plane);
        } else {
            if (rec.contains("MB")) {
                FDS5Const.VentMB mb = VentParser.getMB(rec);
                return this.addVentsForGridFace(rec, surf, mb);
            }
            throw new FDSRecordFormatException(rec, Intl.intl("Vents must have geometry specified."));
        }
        return true;
    }

    private void addVent(FDSParseRecord rec, Vent vent) throws FDSRecordFormatException {
        AABox ventBounds = vent.getGeom().getBoundingBox(new AABox());
        TexOrigin texOrigin = VentParser.parseTexLoc(rec, ventBounds.getMin(), "VENT", "TEXTURE_ORIGIN");
        vent.setTextureOrigin(texOrigin);
        FireSpread fs = this.parseFireSpread(rec, vent.getSurface(), ventBounds);
        vent.setFireSpread(fs);
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", false);
        this.applyColor(vent, color);
        VentParser.markSingleInputForRetrieval(rec, vent, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        vent.setOptions(1, rec.getBoolean("OUTLINE", true));
        vent.setEvac(this.parseEvac(rec, "EVACUATION", "MESH_ID"));
        Vent.OpenProps openProps = this.parseOpenProps(rec);
        if (openProps != null) {
            if (vent.getSurface().getName().equals(PredefSurf.OPEN.name())) {
                vent.setOpenProps(openProps);
            } else {
                this.addWarning(rec, Intl.intl("OPEN vent properties specified for a non-OPEN vent."), Intl.intl("Ignoring OPEN vent properties"));
            }
        }
        this.d_ventMap.put(rec, vent);
        this.flagObjectAdded(vent);
    }

    private Vent.OpenProps parseOpenProps(FDSParseRecord rec) throws FDSRecordFormatException {
        if (!(rec.contains("TMP_EXTERIOR") || rec.contains("MASS_FRACTION") || rec.contains("PRESSURE_RAMP") || rec.contains("DYNAMIC_PRESSURE"))) {
            return null;
        }
        UnitDouble temp = rec.getUnitDouble("TMP_EXTERIOR", true);
        List massFracs = rec.getList("MASS_FRACTION", true);
        IdentityHashMap<ExSpec, UnitDouble> massFracsMap = new IdentityHashMap<ExSpec, UnitDouble>();
        for (int m = 0; m < massFracs.size(); ++m) {
            UnitDouble mf = (UnitDouble)massFracs.get(m);
            if (mf == null || mf.getValueNoUnit() == 0.0) continue;
            ExSpec spec = this.d_specParser.getSpec(m);
            if (spec == null) {
                this.addWarning(rec, String.format(Intl.intl("Could not find SPEC %d"), m + 1), String.format(Intl.intl("Ignoring MASS_FRACTION(%d)"), m + 1));
                continue;
            }
            massFracsMap.put(spec, mf);
        }
        if (rec.contains("PRESSURE_RAMP") && !rec.contains("DYNAMIC_PRESSURE")) {
            this.addWarning(rec, Intl.intl("PRESSURE_RAMP specified without DYNAMIC_PRESSURE"), "");
        }
        UnitDouble pressure = rec.getUnitDouble("DYNAMIC_PRESSURE", true);
        TimeFunction timeFunc = this.parseTimeFunction(rec, (String)null, "PRESSURE_RAMP");
        TimeBasedValue<UnitDouble> pressureVal = new TimeBasedValue<UnitDouble>(pressure, timeFunc);
        return new Vent.OpenProps(temp, pressureVal, massFracsMap);
    }

    private FireSpread parseFireSpread(FDSParseRecord rec, Surface surf, AABox bb) throws FDSRecordFormatException {
        UnitDouble spreadRate = rec.getUnitDouble("SPREAD_RATE");
        if (spreadRate != null && spreadRate.getValueNoUnit() > 0.0) {
            if (!Vent.isValidFireSpreadSurf(surf)) {
                this.addWarning(rec, String.format(Intl.intl("%s is not a valid surface for spreading a fire on a vent."), surf.getName()), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D origin = VentParser.parseLoc(rec, Intl.intl("Vent"), "XYZ", false, false);
            if (origin == null) {
                this.addWarning(rec, Intl.intl("Vent with a fire spread rate did not specify a spread origin."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D min = new UnitPoint3D(bb.getMin(), Geometry.LU);
            UnitPoint3D max = new UnitPoint3D(bb.getMax(), Geometry.LU);
            if (min.xu().compareTo(origin.xu()) > 0 || max.xu().compareTo(origin.xu()) < 0 || min.yu().compareTo(origin.yu()) > 0 || max.yu().compareTo(origin.yu()) < 0 || min.zu().compareTo(origin.zu()) > 0 || max.zu().compareTo(origin.zu()) < 0) {
                this.addWarning(rec, Intl.intl("The fire spread origin must lie on the vent."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            return new FireSpread(origin, spreadRate);
        }
        return null;
    }

    private boolean addVentsForGridFace(FDSParseRecord rec, Surface surf, FDS5Const.VentMB mb) throws FDSRecordFormatException {
        Map<Grid, GridMergeUtil.BoundaryInfo> gridFaces = this.getGridFaces();
        if (gridFaces.isEmpty()) {
            this.addWarning(rec, Intl.intl("Unable to match vent to mesh boundaries."), Intl.intl("Adding vent to Additional Records"));
            return false;
        }
        GridUtil.GridFace gf = null;
        switch (mb) {
            case XMIN: {
                gf = GridUtil.GridFace.XMIN;
                break;
            }
            case XMAX: {
                gf = GridUtil.GridFace.XMAX;
                break;
            }
            case YMIN: {
                gf = GridUtil.GridFace.YMIN;
                break;
            }
            case YMAX: {
                gf = GridUtil.GridFace.YMAX;
                break;
            }
            case ZMIN: {
                gf = GridUtil.GridFace.ZMIN;
                break;
            }
            case ZMAX: {
                gf = GridUtil.GridFace.ZMAX;
            }
        }
        List<Pair<Grid, List<Vent>>> vents = GridUtil.constructVents(this.getContainer().getGridManager().flatten(), gridFaces, surf, gf);
        for (Pair<Grid, List<Vent>> gvents : vents) {
            for (Vent vent : (List)gvents.v2) {
                this.addVent(rec, vent);
            }
        }
        new AddGridBoundaryVentsTask(this.getContainer(), vents).run();
        return true;
    }

    private void addVentsAlongPlane(FDSParseRecord rec, String name, Surface surf, final Plane3d plane) throws FDSRecordFormatException {
        final ArrayList<AARectangle> vfaces = new ArrayList<AARectangle>();
        Map<Grid, GridMergeUtil.BoundaryInfo> meshFaces = this.getGridFaces();
        for (Map.Entry<Grid, GridMergeUtil.BoundaryInfo> entry : meshFaces.entrySet()) {
            for (Face face : entry.getValue().faces) {
                Object bounds;
                AARectangle rect;
                if (!VentParser.equal(face.plane, plane, 1.0E-9) || (rect = AARectangle.construct(((AABox)(bounds = face.getBounds())).getMin(), ((AABox)bounds).getMax())) == null) continue;
                vfaces.add(rect);
            }
        }
        ITest<AABox> test = new ITest<AABox>(){

            @Override
            public Containment test(AABox bounds) {
                int pcount = 0;
                int ncount = 0;
                for (Point3d vert : bounds.getVerts()) {
                    double dot = plane.dot(vert);
                    if (theUtil.eq0(dot, 1.0E-9)) {
                        return Containment.INTERSECTS;
                    }
                    if (theUtil.gt0(dot, 1.0E-9)) {
                        ++pcount;
                    } else {
                        ++ncount;
                    }
                    if (pcount <= 0 || ncount <= 0) continue;
                    return Containment.INTERSECTS;
                }
                return Containment.OUTSIDE;
            }
        };
        IResult<IGeomSource> result = new IResult<IGeomSource>(){

            @Override
            public void mark(IGeomSource obj, Containment ctmt) {
                if (!(obj instanceof IObstruction)) {
                    return;
                }
                IObstruction obst = (IObstruction)obj;
                IGeom geom = obst.getGeom();
                if (geom.isShell() && !obst.getOptions(1)) {
                    return;
                }
                for (IPolygon face : GeomUtil.explode(geom, IPolygon.class)) {
                    AARectangle rect = VentParser.rectFromFace(face, plane);
                    if (rect == null) continue;
                    vfaces.add(rect);
                }
            }
        };
        this.getContainer().getGeomLocator().updateDirty();
        this.getContainer().getGeomLocator().find(test, (IResult<? super IGeomSource>)result, true);
        if (vfaces.isEmpty()) {
            String warning = Intl.intl("Vent does not intersect any solid obstructions.");
            String action = Intl.intl("Skipping vent.");
            this.addWarning(new FDSParseWarning(rec, warning, action));
        } else {
            int count = 0;
            ArrayList<Vent> vents = new ArrayList<Vent>(vfaces.size());
            for (AARectangle rect : vfaces) {
                String vname = vfaces.size() > 1 ? String.format("%s[%d]", name, count++) : name;
                Vent vent = new Vent(vname, surf, rect);
                this.addVent(rec, vent);
                vents.add(vent);
            }
            if (vents.size() == 1) {
                this.addObject((IPyroObject)vents.get(0));
            } else {
                ModelComposite group = new ModelComposite(name);
                group.addAll(vents);
                this.getContainer().getObstructions().add(group);
            }
        }
    }

    private static AARectangle rectFromFace(IFace face, Plane3d plane) {
        if (!(face instanceof IPolygon)) {
            return null;
        }
        IPolygon poly = (IPolygon)face;
        if (!VentParser.equal(PolyUtil.getPlane(poly), plane, 1.0E-9)) {
            return null;
        }
        AABox bounds = face.getBoundingBox(new AABox());
        return AARectangle.construct(bounds.getMin(), bounds.getMax());
    }

    private void applyColor(Vent vent, Color color) {
        if (color == INVISIBLE_COLOR) {
            vent.setVisible(false);
            vent.setColors(new Color[]{null});
        } else {
            vent.setColors(color);
        }
    }

    protected static FDS5Const.VentMB getMB(FDSParseRecord rec) throws FDSRecordFormatException {
        String fdsMB = rec.getString("MB", false);
        if (fdsMB == null) {
            return null;
        }
        for (FDS5Const.VentMB mb : FDS5Const.VentMB.values()) {
            if (!fdsMB.equals(mb.fdsName)) continue;
            return mb;
        }
        throw new FDSRecordFormatException(String.format(Intl.intl("Unrecognized value for %1$S: %2$s"), "MB", fdsMB));
    }

    protected Map<Grid, GridMergeUtil.BoundaryInfo> getGridFaces() {
        if (this.d_gridFaces == null) {
            this.d_gridFaces = GridMergeUtil.mergeGrids(this.getContainer().getGridManager().flatten(), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces;
        }
        return this.d_gridFaces;
    }

    protected static boolean equal(Plane3d plane1, Plane3d plane2, double tol) {
        return plane1.epsilonEquals(plane2, tol) || plane1.epsilonEquals(plane2.negate(), tol);
    }
}

