/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.util.Lists;

public class TableParser
extends AFDS5Parser {
    public TableParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("TABL");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID");
        if (id == null) {
            this.addWarning(rec, Intl.intl("Table entry has no ID."), Intl.intl("Adding table entry to additional records section."));
            return false;
        }
        List<Double> vals = rec.getList("TABLE_DATA", false);
        if (vals == null || vals.isEmpty()) {
            this.addWarning(rec, Intl.intl("Table entry has no values."), Intl.intl("Ignoring table entry."));
            return true;
        }
        if (Lists.containsNull(vals)) {
            throw new FDSRecordFormatException(rec, Intl.intl("Null values are not allowed in table entries."));
        }
        this.getParsingInfo().addTableRow(id, vals);
        return true;
    }
}

