/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.TextureDBMgr;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirDuct;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.FanSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpecInjList;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpeciesInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ZonePath;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ZoneParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Lists;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class SurfaceParser
extends AFDS5Parser {
    private final ExSpecParser d_specParser;
    private final ZoneParser d_zoneParser;

    public SurfaceParser(FDS5ParsingInfo parsingInfo, ExSpecParser specParser, ZoneParser zoneParser) {
        super(parsingInfo);
        this.d_specParser = specParser;
        this.d_zoneParser = zoneParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("SURF");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
        unsupportedFields.add("CELL_SIZE_FACTOR");
        unsupportedFields.add("STRETCH_FACTOR");
        unsupportedFields.add("EMISSIVITY_BACK");
        unsupportedFields.add("SPREAD_RATE");
        unsupportedFields.add("XYZ");
        unsupportedFields.add("EXTERNAL_FLUX");
        unsupportedFields.add("RAMP_EF");
        unsupportedFields.add("TAU_EF");
        unsupportedFields.add("H_FIXED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID");
        if (!this.checkName(rec, id)) {
            return false;
        }
        String fyi = (String)rec.get("FYI");
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", true);
        TextureInfo texInfo = this.parseTexInfo(rec);
        ISurfDesc desc = this.parseSurfaceDesc(rec);
        Surface surf = new Surface(id, color, texInfo, desc);
        if (fyi != null) {
            surf.setFYI(fyi);
        }
        surf.setCustomFDSProps(this.getCustomVals(rec));
        int exists = this.existsStatus(rec, surf, Surface.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        this.getContainer().getSurfaceMgr().add(surf);
        this.flagObjectAdded(surf);
        return true;
    }

    private TextureInfo parseTexInfo(FDSParseRecord rec) {
        String texFn = (String)rec.get("TEXTURE_MAP", false);
        if (texFn == null) {
            return null;
        }
        TextureInfo texinfo = null;
        TextureDBMgr texDBMgr = this.getContainer().getTextureDBMgr();
        TextureDB texDB = texDBMgr.getDatabase();
        if (texDB.names().contains(texFn)) {
            texinfo = new TextureInfo(texDB.getDefaultInfo(texFn));
        } else if (this.getParsingInfo().getParsingFile() != null) {
            try {
                FDS5ParsingInfo pi = this.getParsingInfo();
                File parseFile = new File(pi.getParsingFile());
                File texFile = new File(parseFile.getParentFile(), texFn);
                texinfo = new TextureInfo(texDBMgr.addToDB(texFile));
                String id = texinfo.getTexID();
                TextureInfo dInfo = texDB.getDefaultInfo(id);
                UnitDouble wid = (UnitDouble)rec.get("TEXTURE_WIDTH", true);
                UnitDouble ht = (UnitDouble)rec.get("TEXTURE_HEIGHT", true);
                dInfo.setWidth(wid);
                dInfo.setHeight(ht);
            }
            catch (Throwable t) {
                this.addWarning(rec, "Unable to create texture: " + texFn, "Texture Removed");
                t.printStackTrace();
                texinfo = null;
            }
        }
        if (texinfo != null) {
            if (rec.contains("TEXTURE_WIDTH")) {
                texinfo.setWidth(rec.getUnitDouble("TEXTURE_WIDTH", false));
            }
            if (rec.contains("TEXTURE_HEIGHT")) {
                texinfo.setHeight(rec.getUnitDouble("TEXTURE_HEIGHT", false));
            }
        }
        return texinfo;
    }

    private ISurfDesc parseSurfaceDesc(FDSParseRecord rec) throws FDSRecordFormatException {
        boolean adiabatic = (Boolean)rec.get("ADIABATIC", true);
        if (adiabatic) {
            ISlip slip = this.parseSlip(rec);
            return new SurfDescStatic.Adiabatic(slip);
        }
        ParticleInjection partInj = this.parsePartInj(rec);
        SpecInjList specInj = this.parseSpeciesInjection(rec);
        HeatRelease heatRelease = this.parseHeatRelease(rec);
        Fuel.IReaction reac = this.parseReaction(rec, heatRelease);
        SurfComposition surfComp = this.parseSurfComposition(rec);
        TempRegulation tempReg = this.parseTempRegulation(rec);
        ZonePath leakPath = this.parseZonePath(rec, "LEAK_PATH");
        boolean[] intake = new boolean[1];
        AirFlow airFlow = this.parseAirFlow(rec, null, intake);
        if (!surfComp.d_layers.isEmpty() || rec.contains("ROUGHNESS") || rec.contains("FREE_SLIP") || rec.contains("NO_SLIP") || rec.contains("GEOMETRY")) {
            if (airFlow != null) {
                this.addWarning(rec, Intl.intl("Forced air flow information cannot be specified on layered surfaces."), Intl.intl("Ignoring forced air flow information."));
            }
            if (tempReg != null) {
                this.addWarning(rec, Intl.intl("Surface temperature information cannot be specified on layered surfaces."), Intl.intl("Ignoring temperature information."));
            }
            ISlip slip = this.parseSlip(rec);
            assert (reac != null);
            boolean burnAway = (Boolean)rec.get("BURN_AWAY", true);
            UnitDouble surfDens = rec.getUnitDouble("SURFACE_DENSITY", true);
            if (surfDens.getValueNoUnit() < 0.0) {
                surfDens = null;
            }
            String geomDesc = rec.getString("GEOMETRY");
            LayeredSurfDesc.Geometry geom = LayeredSurfDesc.Geometry.FLAT;
            if (geomDesc != null) {
                if (geomDesc.equals("CYLINDRICAL")) {
                    geom = LayeredSurfDesc.Geometry.CYLINDRICAL;
                } else if (geomDesc.equals("SPHERICAL")) {
                    geom = LayeredSurfDesc.Geometry.SPHERICAL;
                } else {
                    this.addWarning(rec, String.format(Intl.intl("Unknown GEOMETRY, %s."), geomDesc), Intl.intl("Ignoring GEOMETRY."));
                }
            }
            return new LayeredSurfDesc(geom, slip, reac, surfComp, specInj, partInj, burnAway, leakPath, surfDens);
        }
        if (heatRelease != null) {
            if (airFlow != null) {
                this.addWarning(rec, Intl.intl("Forced air flow information cannot be specified on burners."), Intl.intl("Ignoring forced air flow information."));
            }
            if (specInj != null) {
                this.addWarning(rec, Intl.intl("Burning surfaces cannot inject extra species."), Intl.intl("Ignoring extra species."));
            }
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("Burners cannot have a LEAK_PATH."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (tempReg == null) {
                tempReg = TempRegulation.newDefault();
            }
            return new BurnerSurfDesc(tempReg, heatRelease, partInj);
        }
        boolean porous = rec.getBoolean("POROUS", true);
        if (airFlow != null && porous) {
            if (specInj != null) {
                this.addWarning(rec, Intl.intl("Species injection is not allowed on porous surfaces."), Intl.intl("Ignoring species injection."));
            }
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("Fans cannot have a LEAK_PATH."), Intl.intl("Ignoring LEAK_PATH for fan surface."));
            }
            return new FanSurfDesc(airFlow);
        }
        airFlow = this.parseAirFlow(rec, specInj, intake);
        if (airFlow != null) {
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("LEAK_PATH is not allowed on exhaust and supply surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (intake[0]) {
                if (tempReg != null) {
                    this.addWarning(rec, Intl.intl("Temperature information is irrelevant for air intake surfaces."), Intl.intl("Ignoring temperature information."));
                }
                return new InFlowSurfDesc(airFlow);
            }
            if (tempReg == null) {
                tempReg = TempRegulation.newDefault();
            }
            return new BlowerSurfDesc(tempReg, airFlow, partInj);
        }
        if (tempReg != null) {
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("LEAK_PATH is not allowed on temperature-regulated surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            return new ConstantTempSurfDesc(tempReg, partInj);
        }
        if (leakPath != null) {
            return new LeakSurfDesc(leakPath, porous);
        }
        return new SurfDescStatic.Inert();
    }

    private ISlip parseSlip(FDSParseRecord rec) throws FDSRecordFormatException {
        boolean fslip = rec.getBoolean("FREE_SLIP", true);
        boolean nslip = rec.getBoolean("NO_SLIP", true);
        UnitDouble roughness = rec.getUnitDouble("ROUGHNESS", true);
        if (fslip && nslip) {
            this.addWarning(rec, Intl.intl("FREE_SLIP cannot be used in conjunction with NO_SLIP."), Intl.intl("Using NO_SLIP."));
        }
        if ((fslip || nslip) && roughness.getValueNoUnit() != 0.0) {
            this.addWarning(rec, Intl.intl("ROUGHNESS should not be used in conjection with FREE_SLIP or NO_SLIP."), Intl.intl("Ignoring ROUGHNESS"));
        }
        if (nslip) {
            return ISlip.NO_SLIP;
        }
        if (fslip) {
            return ISlip.FREE_SLIP;
        }
        return new ISlip.RoughSlip(roughness);
    }

    private AirDuct parseAirDuct(FDSParseRecord rec) {
        ZonePath zc = this.parseZonePath(rec, "DUCT_PATH");
        if (zc == null) {
            return null;
        }
        UnitDouble maxPressure = rec.getUnitDouble("MAX_PRESSURE", true);
        return new AirDuct(zc, maxPressure);
    }

    private ZonePath parseZonePath(FDSParseRecord rec, String key) {
        int path2;
        if (!rec.contains(key)) {
            return null;
        }
        FDSArray ductPath = rec.getArray(key, true);
        int path1 = (Integer)ductPath.get(0);
        if (path1 == (path2 = ((Integer)ductPath.get(1)).intValue())) {
            this.addWarning(rec, String.format(Intl.intl("%s must specify two different ZONEs."), key), String.format(Intl.intl("Ignoring %s"), key));
            return null;
        }
        Zone zone1 = this.d_zoneParser.get(path1);
        Zone zone2 = this.d_zoneParser.get(path2);
        if (zone1 == null || zone2 == null) {
            int missingZone = zone1 == null ? path1 : path2;
            this.addWarning(rec, String.format(Intl.intl("Could not find ZONE %d."), missingZone), String.format(Intl.intl("Ignoring %s"), key));
            return null;
        }
        return new ZonePath(zone1, zone2);
    }

    private ParticleInjection parsePartInj(FDSParseRecord rec) {
        String partName = (String)rec.get("PART_ID");
        if (partName == null) {
            return null;
        }
        Particle particle = this.getParsingInfo().findObject(Particle.class, partName);
        if (particle == null) {
            this.addWarning(rec, String.format(Intl.intl("The particle, %s, could not be found in the model."), partName), Intl.intl("Ignoring particle."));
            return null;
        }
        int numPartsPerCell = (Integer)rec.get("NPPC", true);
        UnitDouble dtInsert = rec.getUnitDouble("DT_INSERT", false);
        if (dtInsert == null) {
            dtInsert = particle.getDescription().getOutput().d_dtInsert;
        }
        TimeBasedValue<UnitDouble> massFlux = null;
        UnitDouble mf = (UnitDouble)rec.get("PARTICLE_MASS_FLUX", false);
        if (mf != null && mf.getValue(SIUS.unit(45)) > 0.0) {
            if (particle.isMassless()) {
                this.addWarning(rec, Intl.intl("A mass flux is specified for the particle, but the particle is massless."), Intl.intl("Ignoring mass flux."));
                massFlux = null;
            } else {
                TimeFunction tf = this.parseTimeFunction(rec, "TAU_PART", "RAMP_PART");
                massFlux = new TimeBasedValue<UnitDouble>(mf, tf);
            }
        }
        return new ParticleInjection(particle, numPartsPerCell, massFlux, dtInsert);
    }

    private SpecInjList parseSpeciesInjection(FDSParseRecord rec) {
        List massFracValues = rec.getList("MASS_FRACTION", false);
        List massFluxValues = rec.getList("MASS_FLUX", false);
        int injType = -1;
        List values = null;
        if (massFracValues != null && Lists.containsNonNull(massFracValues)) {
            values = massFracValues;
            injType = 1;
        } else if (massFluxValues != null && Lists.containsNonNull(massFluxValues)) {
            values = massFluxValues;
            injType = 0;
        }
        if (values == null) {
            return null;
        }
        TimeBasedValue bgInj = null;
        List taus = rec.getList("TAU_MF", values.size(), false);
        List rampNames = rec.getList("RAMP_MF", values.size(), false);
        ArrayList<SpeciesInjection> injs = new ArrayList<SpeciesInjection>();
        for (int m = 0; m < values.size(); ++m) {
            Object value = values.get(m);
            if (value == null) continue;
            UnitDouble tau = (UnitDouble)taus.get(m);
            String rampName = (String)rampNames.get(m);
            TimeFunction tf = this.parseTimeFunction(rec, tau, rampName);
            if (m == 0) {
                if (injType == 0 && ((UnitDouble)value).getValueNoUnit() > 0.0) {
                    bgInj = new TimeBasedValue(value, tf);
                    continue;
                }
                if (injType != 1 || !((Double)value > 0.0)) continue;
                this.addWarning(rec, Intl.intl("Specifying a mass fraction for the background species is not supported by PyroSim."), Intl.intl("Ignoring mass fraction of background species."));
                continue;
            }
            ExSpec spec = this.d_specParser.getSpec(m - 1);
            if (spec == null) {
                this.addWarning(rec, String.format(Intl.intl("Extra species %d could not be found."), m), String.format(Intl.intl("Ignoring extra species %d."), m));
                continue;
            }
            injs.add(new SpeciesInjection(spec, value, tf));
        }
        if (bgInj == null && injs.isEmpty()) {
            return null;
        }
        return new SpecInjList(injType, bgInj, injs);
    }

    private Backing parseBacking(FDSParseRecord rec) {
        String backingStr = (String)rec.get("BACKING", true);
        if (backingStr.equals("VOID")) {
            UnitDouble airTemp = (UnitDouble)rec.get("TMP_BACK", true);
            return new Backing.AirGap(airTemp);
        }
        if (backingStr.equals("EXPOSED")) {
            return Backing.EXPOSED;
        }
        if (backingStr.equals("INSULATED")) {
            return Backing.INSULATED;
        }
        this.addWarning(rec, String.format(Intl.intl("%s is not a recognized surface backing."), backingStr), String.format(Intl.intl("Ignoring backing."), new Object[0]));
        return Backing.newDefault();
    }

    private HeatRelease parseHeatRelease(FDSParseRecord rec) {
        UnitDouble hrrpua = (UnitDouble)rec.get("HRRPUA", false);
        UnitDouble mlrpua = rec.getUnitDouble("MLRPUA", false);
        if (hrrpua == null && mlrpua == null) {
            return null;
        }
        UnitDouble extCoeff = (UnitDouble)rec.get("E_COEFFICIENT", true);
        TimeFunction func = this.parseTimeFunction(rec, "TAU_Q", "RAMP_Q");
        if (hrrpua != null && mlrpua != null) {
            this.addWarning(rec, String.format(Intl.intl("%1$s and %2$s should not both be specified for a surface."), "HRRPUA", "MLRPUA"), String.format(Intl.intl("Ignoring %s."), "MLRPUA"));
        }
        HeatRelease.Type type = hrrpua != null ? new HeatRelease.HRRType(hrrpua, func) : new HeatRelease.MLRType(mlrpua, func);
        return new HeatRelease(type, extCoeff);
    }

    private TempRegulation parseTempRegulation(FDSParseRecord rec) throws FDSRecordFormatException {
        if (!(rec.contains("TMP_FRONT") || rec.contains("CONVECTIVE_HEAT_FLUX") || rec.contains("NET_HEAT_FLUX"))) {
            return null;
        }
        if (rec.contains("NET_HEAT_FLUX")) {
            if (rec.contains("CONVECTIVE_HEAT_FLUX")) {
                throw new FDSRecordFormatException(Intl.intl("SURFs may not specify both a NET_HEAT_FLUX and CONVECTIVE_HEAT_FLUX"));
            }
            if (rec.contains("TMP_FRONT") || rec.contains("EMISSIVITY")) {
                this.addWarning(rec, Intl.intl("SURF records should not specify TMP_FRONT or EMISSIVITY with NET_HEAT_FLUX"), Intl.intl("Ignoring TMP_FRONT and EMISSIVITY"));
            }
            UnitDouble netHeatFlux = rec.getUnitDouble("NET_HEAT_FLUX", true);
            return TempRegulation.newNetHeatFluxTR(netHeatFlux);
        }
        UnitDouble tmpFront = rec.getUnitDouble("TMP_FRONT", true);
        UnitDouble convHeatFlux = rec.getUnitDouble("CONVECTIVE_HEAT_FLUX", true);
        String rampKey = "RAMP_T";
        String tauKey = "TAU_T";
        if (convHeatFlux.getValueNoUnit() != 0.0) {
            rampKey = "RAMP_Q";
            tauKey = "TAU_Q";
        }
        TimeFunction func = this.parseTimeFunction(rec, tauKey, rampKey);
        double emissivity = (Double)rec.get("EMISSIVITY", true);
        return TempRegulation.newFixedHeatFluxTR(tmpFront, convHeatFlux, func, emissivity);
    }

    private AirFlow parseAirFlow(FDSParseRecord rec, SpecInjList si, boolean[] intake) throws FDSRecordFormatException {
        AirFlow.IProfile profile;
        AirFlow.Rate rate;
        UnitDouble normalVel = (UnitDouble)rec.get("VEL", false);
        UnitDouble volFlux = (UnitDouble)rec.get("VOLUME_FLUX", false);
        UnitDouble massFluxTot = (UnitDouble)rec.get("MASS_FLUX_TOTAL", false);
        Boolean porous = rec.getBoolean("POROUS", false);
        if (normalVel == null && volFlux == null && massFluxTot == null && si == null) {
            return null;
        }
        int specCount = 0;
        if (normalVel != null) {
            ++specCount;
        }
        if (volFlux != null) {
            ++specCount;
        }
        if (massFluxTot != null) {
            ++specCount;
        }
        if (specCount > 1) {
            this.addWarning(rec, String.format(Intl.intl("Only one of %1$s, %2$s, and %3$s can be specified for a surface."), "VEL", "VOLUME_FLUX", "MASS_FLUX_TOTAL"), String.format(Intl.intl("Using %s."), "VEL"));
        }
        TimeFunction func = this.parseTimeFunction(rec, "TAU_V", "RAMP_V");
        porous = (Boolean)rec.get("POROUS", true);
        if (porous.booleanValue()) {
            intake[0] = false;
        }
        FDSArray tanVel = rec.getArray("VEL_T", true);
        if (normalVel != null) {
            normalVel = porous == false ? this.extractFlowRate(normalVel, intake) : normalVel;
            si = this.validateForcedAirSpecInj(rec, si, "VEL", intake[0]);
            rate = new AirFlow.NormalVel(normalVel, (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        } else if (volFlux != null) {
            volFlux = porous == false ? this.extractFlowRate(volFlux, intake) : volFlux;
            si = this.validateForcedAirSpecInj(rec, si, "VOLUME_FLUX", intake[0]);
            rate = new AirFlow.VolumeFlux(volFlux, (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        } else if (massFluxTot != null) {
            massFluxTot = porous == false ? this.extractFlowRate(massFluxTot, intake) : massFluxTot;
            si = this.validateForcedAirSpecInj(rec, si, "MASS_FLUX_TOTAL", intake[0]);
            rate = new AirFlow.TotalMassFlux(massFluxTot, (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        } else {
            assert (si != null);
            intake[0] = false;
            rate = si.injType == 0 ? new AirFlow.ExSpecMassFlux((UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si) : new AirFlow.NormalVel(SIUS.newud(0.0, 8), (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        }
        String profileName = (String)rec.get("PROFILE", true);
        if (profileName == null || profileName.equals(FDS5Const.TOP_HAT)) {
            profile = new AirFlow.TopHatProf();
        } else if (profileName.equals("PARABOLIC")) {
            profile = new AirFlow.ParabolicProf();
        } else if (profileName.equals("ATMOSPHERIC")) {
            UnitDouble origin = (UnitDouble)rec.get("Z0", true);
            double exp = (Double)rec.get("PLE", true);
            profile = new AirFlow.AtmosphericProf(exp, origin);
        } else {
            this.addWarning(rec, String.format(Intl.intl("%s is not a recognized wind profile."), profileName), Intl.intl("Using a top hat wind profile."));
            profile = new AirFlow.TopHatProf();
        }
        AirDuct airDuct = this.parseAirDuct(rec);
        return new AirFlow(rate, profile, airDuct);
    }

    private UnitDouble extractFlowRate(UnitDouble rate, boolean[] intake) {
        if (Double.compare(rate.getValueNoUnit(), 0.0) < 0) {
            intake[0] = false;
            return rate.negate();
        }
        intake[0] = true;
        return rate;
    }

    private SpecInjList validateForcedAirSpecInj(FDSParseRecord rec, SpecInjList spec, String valKey, boolean intake) {
        if (spec != null) {
            if (intake) {
                this.addWarning(rec, Intl.intl("Extra species are irrelevant for air intake surfaces."), Intl.intl("Ignoring extra species for surface."));
                return null;
            }
            if (spec.injType == 0) {
                this.addWarning(rec, String.format(Intl.intl("%1$s cannot be specified with %2$s"), valKey, "MASS_FLUX"), Intl.intl("Ignoring extra species for surface."));
                return null;
            }
        }
        return spec;
    }

    private static boolean valsEqualZero(UnitDouble ... vals) {
        for (UnitDouble val : vals) {
            if (val == null || val.getValueNoUnit() == 0.0) continue;
            return false;
        }
        return true;
    }

    private Fuel.IReaction parseReaction(FDSParseRecord rec, HeatRelease heatRelease) {
        if (heatRelease == null) {
            return new Fuel.MaterialReac();
        }
        UnitDouble igTemp = (UnitDouble)rec.get("IGNITION_TEMPERATURE", false);
        Fuel.ManualReac.IIgnition ignition = igTemp != null ? new Fuel.ManualReac.TemperatureIgnite(igTemp) : new Fuel.ManualReac.ImmediateIgnite();
        UnitDouble heatOfVap = (UnitDouble)rec.get("HEAT_OF_VAPORIZATION", false);
        return new Fuel.ManualReac(heatRelease, heatOfVap, ignition);
    }

    private SurfComposition parseSurfComposition(FDSParseRecord rec) throws FDSRecordFormatException {
        List<SurfComposition.SurfLayer> layers = this.parseLayers(rec);
        UnitDouble innerTemp = (UnitDouble)rec.get("TMP_INNER", true);
        TimeFunction tempRamp = this.parseTimeFunction(rec, "TAU_T", "RAMP_T");
        Backing backing = this.parseBacking(rec);
        boolean porous = rec.getBoolean("POROUS", true);
        Double layerDivide = rec.getDouble("LAYER_DIVIDE", true);
        if (layerDivide != null) {
            String warnMsg = Intl.intl("LAYER_DIVIDE should be >= 0 and <= number of layers.");
            if (layerDivide < 0.0) {
                layerDivide = null;
                this.addWarning(rec, warnMsg, Intl.intl("Using the default LAYER_DIVIDE value."));
            } else if (layerDivide > (double)layers.size()) {
                layerDivide = layers.size();
                this.addWarning(rec, warnMsg, String.format(Intl.intl("Clamped the LAYER_DIVIDE to %d."), layers.size()));
            }
        }
        return new SurfComposition(innerTemp, tempRamp, backing, porous, layerDivide, layers);
    }

    private List<SurfComposition.SurfLayer> parseLayers(FDSParseRecord rec) throws FDSRecordFormatException {
        ArrayList<SurfComposition.SurfLayer> layers = new ArrayList<SurfComposition.SurfLayer>();
        FDSArray matIDs = rec.getArray("MATL_ID", false);
        if (matIDs == null || !matIDs.containsNonNull()) {
            return layers;
        }
        FDSArray thicknesses = rec.getArray("THICKNESS", true);
        FDSArray massFracs = rec.getArray("MATL_MASS_FRACTION", true);
        for (int layerix = 0; layerix < FDS5Const.SURF_LAYER_DIMENSIONS[0]; ++layerix) {
            UnitDouble thickness = (UnitDouble)thicknesses.get(layerix);
            double totalFracSpecified = 0.0;
            ArrayList<SurfComposition.SurfLayer.SurfComponent> comps = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
            ArrayList<Material> noMassFracMats = new ArrayList<Material>();
            for (int compix = 0; compix < FDS5Const.SURF_LAYER_DIMENSIONS[1]; ++compix) {
                String matid = (String)matIDs.get(layerix, compix);
                if (matid == null) continue;
                Material mat = this.getParsingInfo().findObject(Material.class, matid);
                if (mat == null) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find MATL %s."), matid));
                }
                Double massFrac = (Double)massFracs.get(layerix, compix);
                if (massFrac == null) {
                    noMassFracMats.add(mat);
                    continue;
                }
                totalFracSpecified += massFrac.doubleValue();
                comps.add(new SurfComposition.SurfLayer.SurfComponent(massFrac, mat));
            }
            if (comps.isEmpty() && noMassFracMats.isEmpty()) continue;
            if (comps.isEmpty() && noMassFracMats.size() == 1) {
                comps.add(new SurfComposition.SurfLayer.SurfComponent(1.0, (Material)noMassFracMats.get(0)));
            } else {
                if (totalFracSpecified > 1.0000001) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("Material mass fractions in layer %d add to more than 1."), layerix + 1));
                }
                if (totalFracSpecified < 0.9999999 && noMassFracMats.isEmpty()) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("Material mass fractions in layer %d add to less than 1."), layerix + 1));
                }
                if (!noMassFracMats.isEmpty()) {
                    this.addWarning(rec, String.format(Intl.intl("A mass fraction was not specified for every material in layer %d."), layerix + 1), String.format(Intl.intl("Distributing remaining mass fraction evenly among materials with no specified mass fraction."), layerix + 1));
                    double distFrac = (1.0 - totalFracSpecified) / (double)noMassFracMats.size();
                    if (distFrac != 0.0) {
                        for (Material mat : noMassFracMats) {
                            comps.add(new SurfComposition.SurfLayer.SurfComponent(distFrac, mat));
                        }
                    }
                }
            }
            layers.add(new SurfComposition.SurfLayer(thickness, comps));
        }
        return layers;
    }
}

