/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.FireSuppression;
import pyrosim.legacy_2012_1.domain.reaction.Fuel;
import pyrosim.legacy_2012_1.domain.reaction.HeatReleaseRate;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ReactionParser
extends AFDS5Parser {
    public ReactionParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.contains("BOF") || rec.contains("E") || rec.contains("FUEL") || rec.contains("N_S") || rec.contains("NU") || rec.contains("OXIDIZER")) {
            this.addWarning(rec, Intl.intl("PyroSim does not currently support finite-rate reactions."), Intl.intl("Adding reaction to additional records section."));
            return false;
        }
        String id = (String)rec.get("ID");
        if (id == null || id.trim().equals("")) {
            id = Util.getUniqueName(this.getContainer().getReactions(), Intl.intl("REAC"));
        }
        Reaction reac = new Reaction(id);
        reac.setFYI(rec.getString("FYI", false));
        reac.setFuel(this.parseFuel(rec));
        reac.setHRR(this.parseHRR(rec));
        reac.setByproducts(this.parseByproducts(rec));
        reac.setSuppression(this.parseSuppression(rec));
        reac.setCustomFDSProps(this.getCustomVals(rec));
        int exists = this.existsStatus(rec, reac, Reaction.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        ReactionList reacs = this.getContainer().getReactions();
        reacs.add(reac);
        this.flagObjectAdded(reac);
        return true;
    }

    private Fuel parseFuel(FDSParseRecord rec) {
        double carbon = (Double)rec.get("C", true);
        double hydrogen = (Double)rec.get("H", true);
        double oxygen = (Double)rec.get("O", true);
        double nitrogen = (Double)rec.get("N", true);
        double other = (Double)rec.get("OTHER", true);
        UnitDouble mwOther = other > 0.0 ? rec.getUnitDouble("MW_OTHER", true) : null;
        double ambMassFracO2 = (Double)rec.get("Y_O2_INFTY", true);
        double massFracFuel = (Double)rec.get("Y_F_INLET", true);
        return new Fuel(carbon, hydrogen, oxygen, nitrogen, other, mwOther, ambMassFracO2, massFracFuel);
    }

    private HeatReleaseRate parseHRR(FDSParseRecord rec) {
        return new HeatReleaseRate(rec.getBoolean("EDDY_DISSIPATION", true), rec.getDouble("C_EDC", true), rec.getUnitDouble("HRRPUA_SHEET", true), rec.getUnitDouble("HRRPUV_AVERAGE", true));
    }

    private FireSuppression parseSuppression(FDSParseRecord rec) {
        double limitingOxygenIndex = (Double)rec.get("X_O2_LL", true);
        if (limitingOxygenIndex == 0.0) {
            return null;
        }
        UnitDouble critFlameTemp = (UnitDouble)rec.get("CRITICAL_FLAME_TEMPERATURE", true);
        return new FireSuppression(limitingOxygenIndex, critFlameTemp);
    }

    private Byproducts parseByproducts(FDSParseRecord rec) {
        Byproducts.Energy energy;
        double co = (Double)rec.get("CO_YIELD", true);
        double h2 = (Double)rec.get("H2_YIELD", true);
        double sootYield = (Double)rec.get("SOOT_YIELD", true);
        Soot soot = sootYield > 0.0 ? this.parseSoot(rec) : null;
        boolean ideal = (Boolean)rec.get("IDEAL", true);
        if (rec.contains("HEAT_OF_COMBUSTION")) {
            UnitDouble hoc = (UnitDouble)rec.get("HEAT_OF_COMBUSTION", false);
            energy = new Byproducts.FuelEnergy(hoc, ideal);
        } else {
            UnitDouble epumo2 = (UnitDouble)rec.get("EPUMO2", true);
            energy = new Byproducts.OxygenEnergy(epumo2, ideal);
        }
        return new Byproducts(co, h2, sootYield, soot, energy);
    }

    private Soot parseSoot(FDSParseRecord rec) {
        double hFrac = (Double)rec.get("SOOT_H_FRACTION", true);
        UnitDouble maxVis = (UnitDouble)rec.get("MAXIMUM_VISIBILITY", true);
        double visFactor = (Double)rec.get("VISIBILITY_FACTOR", true);
        UnitDouble massExtCoeff = visFactor > 0.0 ? rec.getUnitDouble("MASS_EXTINCTION_COEFFICIENT", true) : null;
        return new Soot(hFrac, maxVis, massExtCoeff, visFactor);
    }
}

