/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;

public class RampParser
extends AFDS5Parser {
    public RampParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("RAMP");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = rec.getString("ID");
        if (id == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Ramp does not have ID."));
        }
        Double f = rec.getDouble("F");
        if (f == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Ramp does not have an F."));
        }
        Double t = rec.getDouble("T");
        Double x = rec.getDouble("X");
        if (t == null && x == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Ramp does not have a T or X."));
        }
        if (t == null) {
            t = x;
        }
        String devcID = rec.getString("DEVC_ID");
        this.getParsingInfo().addRampValue(rec, id, t, f, devcID);
        return true;
    }
}

