/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;

public class Plot3dParser
extends AFDS5Parser {
    public Plot3dParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DUMP");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray quantities = rec.getArray("PLOT3D_QUANTITY", true);
        if (quantities == null) {
            return true;
        }
        FDSArray exSpecIds = rec.getArray("PLOT3D_SPEC_ID", true);
        FDSArray partIds = rec.getArray("PLOT3D_PART_ID", true);
        FDSArray veloIndexes = rec.getArray("PLOT3D_VELO_INDEX", true);
        ArrayList<IQuantity> measurements = new ArrayList<IQuantity>(5);
        VelocitySign vs = VelocitySign.ALWAYS_POSITIVE;
        for (int m = 0; m < Math.min(quantities.getTotalLength(), 5); ++m) {
            String quantity = (String)quantities.get(m);
            if (quantity == null) continue;
            String exSpecId = exSpecIds != null ? (String)exSpecIds.get(m) : null;
            String partId = partIds != null ? (String)partIds.get(m) : null;
            Integer veloIndex = veloIndexes != null ? (Integer)veloIndexes.get(m) : null;
            IQuantity msr = this.getQuantityMap().parseQuantity(this.getParsingInfo(), rec, quantity, partId, exSpecId, null, null, null);
            if (msr == null) continue;
            if (!QuantityUtil.canOutputAll(msr.get(), 64)) {
                this.addWarning(rec, String.format(Intl.intl("Quantity %s is invalid for Plot3D output."), quantity), Intl.intl("Quantity ignored"));
                continue;
            }
            measurements.add(msr);
            if (!msr.get().equals((Object)Quantity.VELOCITY)) continue;
            vs = this.parseVelocitySign(rec, veloIndex);
        }
        Plot3d plot3d = this.getContainer().getPlot3d();
        plot3d.setQuantities(measurements);
        plot3d.setVelocitySign(vs);
        this.flagObjectAdded(plot3d);
        return true;
    }
}

