/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.MeasureOutInfo;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;

public class PinConnParser
extends AFDS5Parser {
    private final Map<String, List<IOutPin>> d_idPinMap = new HashMap<String, List<IOutPin>>();
    private final List<InputRetrieval> d_retrievalList = new ArrayList<InputRetrieval>();
    private final Map<IOutPin, String> d_outPinCtrlNameMap = new IdentityHashMap<IOutPin, String>();

    public PinConnParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
        for (PyroMod src : parsingInfo.getSourceContainers()) {
            for (IDevice devc : src.getDevices().flatten()) {
                if (devc instanceof LayerMeasurer) {
                    LayerMeasurer msr = (LayerMeasurer)devc;
                    this.addMsrInfoNames(msr.getHeightInfo());
                    this.addMsrInfoNames(msr.getLowerTempInfo());
                    this.addMsrInfoNames(msr.getUpperTempInfo());
                    continue;
                }
                if (!(devc instanceof ISignalSource)) continue;
                ISignalSource dsrc = (ISignalSource)((Object)devc);
                for (IOutPin iOutPin : dsrc.getOutputPins()) {
                    this.addOutputName(iOutPin, devc.getName());
                }
            }
        }
    }

    private void addMsrInfoNames(MeasureOutInfo mi) {
        List<IOutPin> pins = mi.getPins();
        if (pins.isEmpty()) {
            return;
        }
    }

    public List<InputRetrieval> getRetrievals() {
        return Collections.unmodifiableList(this.d_retrievalList);
    }

    public Map<IOutPin, String> getPinFDSNameMap() {
        return this.d_outPinCtrlNameMap;
    }

    public boolean outputNameExists(String fdsID) {
        return this.d_idPinMap.containsKey(fdsID);
    }

    public boolean addOutputName(IOutPin outPin, String fdsID) {
        List<IOutPin> list = this.d_idPinMap.get(fdsID);
        if (list == null) {
            list = new ArrayList<IOutPin>();
            this.d_idPinMap.put(fdsID, list);
        }
        this.d_outPinCtrlNameMap.put(outPin, fdsID);
        list.add(outPin);
        return true;
    }

    public List<IOutPin> getPins(String fdsID) {
        return this.d_idPinMap.get(fdsID);
    }

    public void markInputForRetrieval(FDSParseRecord rec, IInPin inPin, List<String> inNames) {
        if (inNames == null) {
            inNames = new ArrayList<String>(0);
        }
        this.d_retrievalList.add(new InputRetrieval(rec, inPin, inNames));
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("CTRL");
        types.add("DEVC");
        types.add("OBST");
        types.add("VENT");
        types.add("HOLE");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        for (InputRetrieval ret : this.d_retrievalList) {
            for (String inputID : ret.inputIDs) {
                List<IOutPin> outPins = this.d_idPinMap.get(inputID);
                if (outPins == null) {
                    throw new FDSRecordFormatException(ret.rec, String.format(Intl.intl("Could not find control input: %s"), inputID));
                }
                boolean connected = false;
                for (IOutPin outPin : outPins) {
                    if (!ret.inPin.canConnect(outPin)) continue;
                    ret.inPin.connect(outPin);
                    connected = true;
                    break;
                }
                if (connected) continue;
                throw new FDSRecordFormatException(ret.rec, String.format(Intl.intl("Invalid input, %s."), inputID));
            }
        }
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        return false;
    }

    public static class InputRetrieval {
        public final FDSParseRecord rec;
        public final IInPin inPin;
        public final List<String> inputIDs;

        public InputRetrieval(FDSParseRecord rec, IInPin inPin, List<String> inputIDs) {
            this.rec = rec;
            this.inPin = inPin;
            this.inputIDs = inputIDs;
        }
    }
}

