/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PersParser
extends AFDS5Parser {
    public PersParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        Color c;
        HashMap<String, Object> props;
        String id;
        boolean containsGlobalData = false;
        boolean containsInstanceData = false;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process PERS record: ID missing"), Intl.intl("PERS Record Ignored"));
            return false;
        }
        PersList mgr = this.getContainer().getPersList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            this.addWarning(rec, Intl.intl("Unable to process PERS record: Duplicate ID"), Intl.intl("PERS Record Ignored"));
            return false;
        }
        String strDefaults = null;
        Pers defaults = null;
        if (rec.contains("DEFAULT_PROPERTIES")) {
            strDefaults = rec.getString("DEFAULT_PROPERTIES");
            defaults = PersList.PREDEFINED.get(strDefaults);
            if (defaults == null) {
                this.addWarning(rec, String.format(Intl.intl("Unknown default properties type: %s"), strDefaults), Intl.intl("Default properties reset to null."));
            }
            containsInstanceData = true;
        }
        if ((props = new HashMap<String, Object>(rec.getProperties())).containsKey("AVATAR_COLOR")) {
            c = this.parseColor(rec, "AVATAR_RGB", "AVATAR_COLOR", null, false);
            props.remove("AVATAR_RGB");
            props.put("AVATAR_COLOR", c);
        }
        if (props.containsKey("DEAD_COLOR")) {
            c = this.parseColor(rec, "DEAD_RGB", "DEAD_COLOR", null, false);
            props.remove("DEAD_RGB");
            props.put("DEAD_COLOR", c);
        }
        Pers globals = this.getContainer().getSimParams().getPersGlobals();
        HashSet instanceProps = new HashSet();
        for (String prop : props.keySet()) {
            if (instanceProps.contains(prop)) continue;
            globals.setProp(prop, props.get(prop));
            containsGlobalData = true;
            this.flagObjectAdded(this.getContainer().getSimParams());
            this.flagEvac();
        }
        Pers p = new Pers(id, defaults);
        if (props.containsKey("FYI")) {
            p.setProp("FYI", props.get("FYI"));
            containsInstanceData = true;
        }
        for (String prop : props.keySet()) {
            if (!instanceProps.contains(prop) || theUtil.equal(prop, "ID") || theUtil.equal(prop, "FYI") || theUtil.equal(prop, "DEFAULT_PROPERTIES")) continue;
            p.setProp(prop, props.get(prop));
            containsInstanceData = true;
        }
        if (!containsGlobalData || containsInstanceData) {
            mgr.add(p);
            this.flagObjectAdded(p);
            this.flagEvac();
        }
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PERS");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

