/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Collection;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.tasks.FillGridsWithPartsTask;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class PartCloudParser
extends AFDS5Parser {
    private Set<Particle> d_staticParticles = new IdentityHashSet<Particle>();

    public PartCloudParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PART");
        types.add("INIT");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        for (FDSParseRecord rec : recs) {
            String id;
            Particle part;
            boolean staticPart;
            if (!rec.getType().equals("PART") || !(staticPart = rec.getBoolean("STATIC", true).booleanValue()) || (part = (id = rec.getString("ID")) != null ? this.getParsingInfo().findObject(Particle.class, id) : null) == null) continue;
            this.d_staticParticles.add(part);
        }
        super.process(recs, unprocessed);
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.getType().equals("PART")) {
            return this.processAsPart(rec);
        }
        if (rec.getType().equals("INIT")) {
            return this.processAsInit(rec);
        }
        return false;
    }

    protected boolean processAsPart(FDSParseRecord rec) throws FDSRecordFormatException {
        String partid = (String)rec.get("ID");
        return this.parsePartCloud(rec, partid, "NUMBER_INITIAL_DROPLETS", "MASS_PER_VOLUME", null, null, "XB");
    }

    protected boolean processAsInit(FDSParseRecord rec) throws FDSRecordFormatException {
        String partid = rec.getString("PART_ID");
        return this.parsePartCloud(rec, partid, "NUMBER_INITIAL_DROPLETS", "MASS_PER_VOLUME", "DT_INSERT", "MASS_PER_TIME", "XB");
    }

    protected boolean parsePartCloud(FDSParseRecord rec, String partid, String numDropsKey, String massPerVolKey, String dtKey, String massPerTimeKey, String xbKey) throws FDSRecordFormatException {
        int numDrops = (Integer)rec.get(numDropsKey, true);
        if (numDrops == 0) {
            return true;
        }
        Particle part = this.findParticle(rec, partid);
        if (part == null) {
            return true;
        }
        String cloudID = rec.getComment().trim();
        if (cloudID == null || cloudID.isEmpty()) {
            cloudID = partid.contains(Intl.intl("Cloud")) ? partid : String.format(Intl.intl("%s Cloud"), partid);
        }
        boolean isStatic = this.d_staticParticles.contains(part);
        PartCloud.ConstDropletCount dropCount = new PartCloud.ConstDropletCount(numDrops);
        PartCloud.IInsertion insertion = this.parseInsertion(rec, massPerVolKey, dtKey, massPerTimeKey);
        if (rec.contains(xbKey)) {
            AABoxGeom geom = PartCloudParser.parseXBGeom(rec, rec.getType(), xbKey, true);
            PartCloud cloud = new PartCloud(cloudID, part, geom);
            cloud.setInsertion(insertion);
            cloud.setInitDrops(dropCount);
            cloud.setStatic(isStatic);
            this.getContainer().getObstructions().add(cloud);
            this.flagObjectAdded(cloud);
        } else {
            FillGridsWithPartsTask task = new FillGridsWithPartsTask(this.getContainer(), cloudID, this.getContainer().getGridManager().flatten(), part, dropCount, insertion, isStatic, false);
            task.run();
            this.flagObjectsAdded(task.getAddedObjects());
        }
        return true;
    }

    protected Particle findParticle(FDSParseRecord rec, String partid) {
        if (partid == null) {
            this.addWarning(rec, Intl.intl("Missing PART_ID for initial droplets."), Intl.intl("Ignoring initial droplets."));
            return null;
        }
        Particle part = this.getParsingInfo().findObject(Particle.class, partid);
        if (part == null) {
            this.addWarning(rec, String.format(Intl.intl("Could not find particle, %s, for initial droplets."), partid), Intl.intl("Ignoring initial droplets."));
            return null;
        }
        return part;
    }

    protected PartCloud.IInsertion parseInsertion(FDSParseRecord rec, String massPerVolKey, String dtKey, String massPerTimeKey) {
        boolean forceGet = dtKey == null || !rec.contains(dtKey);
        UnitDouble massPerVol = rec.getUnitDouble(massPerVolKey, forceGet);
        if (massPerVol != null) {
            return new PartCloud.InsertOnce(massPerVol);
        }
        UnitDouble dt = rec.getUnitDouble(dtKey);
        assert (dt != null);
        UnitDouble massPerTime = rec.getUnitDouble(massPerTimeKey, true);
        return new PartCloud.InsertPeriodically(dt, massPerTime);
    }
}

