/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class MaterialParser
extends AFDS5Parser {
    private final Map<String, Material> d_matPlaceholderMap = new HashMap<String, Material>();
    private final Map<String, FDSParseRecord> d_placeholderRefMap = new HashMap<String, FDSParseRecord>();
    private final List<Pair<Material, FDSParseRecord>> d_parsedMats = new ArrayList<Pair<Material, FDSParseRecord>>();

    public MaterialParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("MATL");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public void done() throws FDSRecordFormatException {
        for (Map.Entry<String, FDSParseRecord> entry : this.d_placeholderRefMap.entrySet()) {
            Material parsedMat = this.getParsingInfo().findObject(Material.class, entry.getKey());
            if (parsedMat != null) continue;
            throw new FDSRecordFormatException(entry.getValue(), String.format(Intl.intl("Could not find MATL %s."), entry.getKey()));
        }
        for (Pair pair : this.d_parsedMats) {
            if (((Material)pair.v1).hasValidResidues()) continue;
            throw new FDSRecordFormatException((FDSParseRecord)pair.v2, Intl.intl("Material contains a residue cycle."));
        }
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String fyi;
        String id = (String)rec.get("ID", false);
        if (!this.checkName(rec, id)) {
            return false;
        }
        Material m = this.d_matPlaceholderMap.get(id);
        if (m == null) {
            m = new Material(id);
        }
        if ((fyi = (String)rec.get("FYI")) != null) {
            m.setFYI(fyi);
        }
        m.setThermalProps(this.getThermalProps(rec));
        m.setPyrolysis(this.getPyrolysis(rec));
        m.setCustomFDSProps(this.getCustomVals(rec));
        int exists = this.existsStatus(rec, m, Material.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        this.getContainer().getMaterialMgr().add(m);
        this.flagObjectAdded(m);
        this.d_parsedMats.add(new Pair<Material, FDSParseRecord>(m, rec));
        return true;
    }

    private ThermalProps getThermalProps(FDSParseRecord rec) throws FDSRecordFormatException {
        IHeatBasedValue conductivity = this.getRampableValue(rec, "CONDUCTIVITY", "CONDUCTIVITY_RAMP", RampInputs.HEAT, 19);
        IHeatBasedValue specHeat = this.getRampableValue(rec, "SPECIFIC_HEAT", "SPECIFIC_HEAT_RAMP", RampInputs.HEAT, 11);
        UnitDouble density = rec.getUnitDouble("DENSITY", true);
        UnitDouble absorpCoeff = rec.getUnitDouble("ABSORPTION_COEFFICIENT", true);
        double emissivity = rec.getDouble("EMISSIVITY", true);
        return new ThermalProps(conductivity, density, specHeat, emissivity, absorpCoeff);
    }

    private IPyrolysis getPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        LiquidPyrolysis lp = this.getLiquidPyrolysis(rec);
        if (lp != null) {
            return lp;
        }
        return this.getSolidPyrolysis(rec);
    }

    private LiquidPyrolysis getLiquidPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble boilingTemp = rec.getUnitDouble("BOILING_TEMPERATURE", false);
        if (boilingTemp == null) {
            return null;
        }
        Integer numReacs = rec.getInteger("N_REACTIONS", false);
        if (numReacs != null && numReacs != 1) {
            throw new FDSRecordFormatException(rec, Intl.intl("Liquid materials must have one reaction."));
        }
        LiquidReaction.Rate rate = new LiquidReaction.Rate(boilingTemp);
        List<ReacByproducts> byproducts = this.getReacByproducts(rec, 1);
        if (byproducts.get((int)0).d_heat == null) {
            UnitDouble hor = SIUS.newud(0.0, 46);
            this.addWarning(rec, String.format(Intl.intl("Liquid materials should specify %s."), "HEAT_OF_REACTION"), String.format(Intl.intl("Assuming a %1$s of %2$s."), "HEAT_OF_REACTION", Global.format(hor)));
            ReacByproducts oldbyp = byproducts.get(0);
            ReacByproducts newbyp = new ReacByproducts(oldbyp.d_nuFuel, oldbyp.d_nuWater, oldbyp.d_nuResidue, oldbyp.getResidue(), hor);
            byproducts = Arrays.asList(newbyp);
        }
        LiquidReaction reac = new LiquidReaction(rate, byproducts.get(0));
        UnitDouble hoc = rec.getUnitDouble("HEAT_OF_COMBUSTION", false);
        UnitDouble iniVaporFlux = rec.getUnitDouble("INITIAL_VAPOR_FLUX", true);
        return new LiquidPyrolysis(hoc, iniVaporFlux, reac);
    }

    private SolidPyrolysis getSolidPyrolysis(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble hoc = rec.getUnitDouble("HEAT_OF_COMBUSTION", true);
        Integer numReacs = rec.getInteger("N_REACTIONS", true);
        List<ReacByproducts> byproducts = this.getReacByproducts(rec, numReacs);
        List<SolidReaction.Rate> rates = this.getSolidRates(rec, numReacs);
        ArrayList<SolidReaction> reacs = new ArrayList<SolidReaction>(numReacs);
        for (int m = 0; m < numReacs; ++m) {
            reacs.add(new SolidReaction(rates.get(m), byproducts.get(m)));
        }
        return new SolidPyrolysis(hoc, reacs);
    }

    private List<ReacByproducts> getReacByproducts(FDSParseRecord rec, int numRequired) throws FDSRecordFormatException {
        ArrayList<ReacByproducts> byproducts = new ArrayList<ReacByproducts>(numRequired);
        List nuFuels = rec.getList("NU_FUEL", numRequired, true);
        List nuWaters = rec.getList("NU_WATER", numRequired, true);
        List nuResidues = rec.getList("NU_RESIDUE", numRequired, true);
        List residues = rec.getList("RESIDUE", numRequired, true);
        List heats = rec.getList("HEAT_OF_REACTION", numRequired, true);
        for (int m = 0; m < numRequired; ++m) {
            double nuResidue;
            double nuWater;
            double nuFuel;
            double nuRes = (Double)nuResidues.get(m);
            Material resMat = null;
            if (nuRes > 0.0) {
                String resName = (String)residues.get(m);
                if (resName == null) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("A residue fraction was specified for reaction %d, but no residue material was specified."), m));
                }
                resMat = this.getResidueMat(rec, resName);
            }
            if ((nuFuel = ((Double)nuFuels.get(m)).doubleValue()) + (nuWater = ((Double)nuWaters.get(m)).doubleValue()) + (nuResidue = ((Double)nuResidues.get(m)).doubleValue()) > 1.0) {
                this.addWarning(rec, Intl.intl("The total yield for a reaction must be less than or equal to 1."), Intl.intl("None"));
            }
            byproducts.add(new ReacByproducts((Double)nuFuels.get(m), (Double)nuWaters.get(m), nuRes, resMat, (UnitDouble)heats.get(m)));
        }
        return byproducts;
    }

    private List<SolidReaction.Rate> getSolidRates(FDSParseRecord rec, int numRequired) throws FDSRecordFormatException {
        List tempExps = rec.getList("N_T", numRequired, true);
        List massFracExps = rec.getList("N_S", numRequired, true);
        List igTemps = rec.getList("THRESHOLD_TEMPERATURE", numRequired, true);
        List<SolidReaction.Rate.ISpecification> specs = this.getSolidRateSpecs(rec, numRequired);
        ArrayList<SolidReaction.Rate> rates = new ArrayList<SolidReaction.Rate>(numRequired);
        for (int m = 0; m < numRequired; ++m) {
            rates.add(new SolidReaction.Rate((Double)massFracExps.get(m), (Double)tempExps.get(m), (UnitDouble)igTemps.get(m), specs.get(m)));
        }
        return rates;
    }

    private List<SolidReaction.Rate.ISpecification> getSolidRateSpecs(FDSParseRecord rec, int numRequired) throws FDSRecordFormatException {
        ArrayList<SolidReaction.Rate.ISpecification> specs = new ArrayList<SolidReaction.Rate.ISpecification>(numRequired);
        List as = rec.getList("A", numRequired, true);
        List es = rec.getList("E", numRequired, false);
        List refTemps = rec.getList("REFERENCE_TEMPERATURE", numRequired, false);
        List heatingRates = rec.getList("HEATING_RATE", numRequired, true);
        List pyrolysisRanges = rec.getList("PYROLYSIS_RANGE", numRequired, true);
        for (int m = 0; m < numRequired; ++m) {
            UnitDouble e = (UnitDouble)es.get(m);
            if (e != null) {
                specs.add(new SolidReaction.Rate.AESpec((UnitDouble)as.get(m), e));
                continue;
            }
            UnitDouble refTemp = (UnitDouble)refTemps.get(m);
            if (refTemp != null) {
                specs.add(new SolidReaction.Rate.RefSpec(refTemp, (UnitDouble)pyrolysisRanges.get(m), (UnitDouble)heatingRates.get(m)));
                continue;
            }
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Material is missing A and E parameters for reaction %d."), m + 1));
        }
        return specs;
    }

    private Material getResidueMat(FDSParseRecord refRec, String resName) {
        Material resMat = this.getParsingInfo().findObject(Material.class, resName);
        if (resMat == null) {
            resMat = new Material(resName);
            this.d_matPlaceholderMap.put(resName, resMat);
            this.d_placeholderRefMap.put(resName, refRec);
        }
        return resMat;
    }

    private IHeatBasedValue getRampableValue(FDSParseRecord rec, String valID, String rampID, IRampInput input, int fUnit) throws FDSRecordFormatException {
        IHeatBasedValue value;
        String valueRampID = rec.getString(rampID);
        if (valueRampID != null) {
            Ramp r = this.getParsingInfo().getRamp(valueRampID, input, fUnit, true);
            if (r == null) {
                throw new FDSRecordFormatException(rec, Intl.intl("Invalid ramp specified."));
            }
            value = new IHeatBasedValue.Custom(r);
        } else {
            UnitDouble udval = rec.getUnitDouble(valID, true);
            value = udval != null ? new IHeatBasedValue.Constant(udval) : null;
        }
        return value;
    }
}

