/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class IsofParser
extends AFDS5Parser {
    public IsofParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("ISOF");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        IQuantity measurement = this.parseQuantity(rec, "QUANTITY", null, "SPEC_ID", null, null, null, 32, Intl.intl("ISOF ignored"), true, false);
        if (measurement == null) {
            return false;
        }
        Unit unit = SIUS.unit(measurement.get().unitType);
        List<UnitDouble> values = rec.getUnitDoubleList("VALUE", unit, false);
        if (values == null) {
            this.addWarning(rec, Intl.intl("No values specified for ISOF record."), Intl.intl("ISOF record ignored"));
            return false;
        }
        Isosurface isof = this.getContainer().getIsofList().getIso(measurement);
        if (isof == null) {
            isof = new Isosurface(measurement, values);
            this.getContainer().getIsofList().add(isof);
        } else {
            values.addAll(isof.getContours());
            isof.setContours(values);
        }
        if (measurement.get().equals((Object)Quantity.VELOCITY)) {
            int veloIndex = rec.getInteger("VELO_INDEX", true);
            VelocitySign vs = this.parseVelocitySign(rec, veloIndex);
            isof.setVelocitySign(vs);
        }
        this.flagObjectAdded(isof);
        return true;
    }
}

