/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.geom.InitRegion;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class InitParser
extends AFDSObjParser {
    private final ExSpecParser d_exSpecs;

    public InitParser(FDS5ParsingInfo parsingInfo, ExSpecParser exSpecs) {
        super(parsingInfo);
        this.d_exSpecs = exSpecs;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("INIT");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        AABoxGeom region;
        UnitDouble density = rec.getUnitDouble("DENSITY");
        UnitDouble temp = rec.getUnitDouble("TEMPERATURE");
        List exSpecs = rec.getList("MASS_FRACTION", false);
        if (density == null && temp == null && exSpecs == null) {
            return true;
        }
        String name = rec.getComment().trim();
        if (name == null || name.isEmpty()) {
            name = Intl.intl("Init Region");
        }
        if ((region = InitParser.parseXBGeom(rec, "INIT", "XB", false)) == null) {
            AABox modelBounds = new AABox();
            for (Grid grid : this.getParsingInfo().getContainer().getGridManager().flatten()) {
                modelBounds.add(grid.getBounds());
            }
            region = new AABoxGeom(modelBounds);
        }
        InitRegion init = new InitRegion(name, region);
        init.setDensity(density);
        init.setTemperature(temp);
        if (exSpecs != null) {
            IdentityHashMap<ExSpec, UnitDouble> specMF = new IdentityHashMap<ExSpec, UnitDouble>(exSpecs.size());
            for (int m = 0; m < exSpecs.size(); ++m) {
                UnitDouble mf = (UnitDouble)exSpecs.get(m);
                if (mf == null || mf.getValueNoUnit() == 0.0) continue;
                ExSpec spec = this.d_exSpecs.getSpec(m);
                if (spec == null) {
                    String msg = String.format(Intl.intl("Extra species %d could not be found."), m + 1);
                    String action = String.format(Intl.intl("Ignoring extra species %d."), m + 1);
                    this.addWarning(rec, msg, action);
                    continue;
                }
                specMF.put(spec, mf);
            }
            init.setExtraSpecies(specMF);
        }
        Pair<String, List<InitRegion>> toAdd = this.applyMult(rec, "MULT_ID", init);
        this.addObjects((String)toAdd.v1, (List)toAdd.v2);
        return true;
    }
}

