/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.geom.Hole;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;

public class HoleParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;

    public HoleParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("HOLE");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String name = this.generateName(rec, Intl.intl("Hole"));
        AABoxGeom geom = HoleParser.parseXBGeom(rec, "HOLE", "XB", true);
        Hole hole = new Hole(name, geom);
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            hole.setVisible(false);
            hole.setColors(new Color[]{null});
        } else {
            hole.setColors(color);
        }
        hole.setEvac(this.parseEvac(rec, "EVACUATION", "MESH_ID"));
        HoleParser.markSingleInputForRetrieval(rec, hole, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        this.addObject(hole);
        return true;
    }
}

