/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.controls.Util;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.io.fds.FDSParseException;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParser;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordParser;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.BoundaryParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ControlParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.CorrParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.DeviceParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.DoorParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EntrParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EvacParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EvhoParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EvssParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExitParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.GridParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.HoleParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.HvacParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.InitParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.IsofParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.MaterialParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.MultParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ObstParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PartCloudParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ParticleParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PersParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnFinisher;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.Plot3dParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ProfParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PropParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.RampFinisher;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.RampParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ReactionParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SimParamsParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SliceParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.StatisticsParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SurfaceParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.TableParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.VentParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ZoneParser;

public class FDS5Parser
extends FDSParser {
    @Override
    protected List<? extends IFDSRecordParser> createParsers(FDSParsingInfo pi) {
        FDS5ParsingInfo pi5 = (FDS5ParsingInfo)pi;
        ExSpecParser exSpecParser = new ExSpecParser(pi5);
        PinConnParser pinConnsParser = new PinConnParser(pi5);
        ControlParser ctrlParser = new ControlParser(pi5, pinConnsParser);
        PropParser propParser = new PropParser(pi5);
        ZoneParser zoneParser = new ZoneParser(pi5);
        SimParamsParser spParser = new SimParamsParser(pi5);
        VentParser ventParser = new VentParser(pi5, pinConnsParser, exSpecParser);
        return Arrays.asList(new MultParser(pi5), new GridParser(pi5), zoneParser, new RampParser(pi5), new TableParser(pi5), exSpecParser, new InitParser(pi5, exSpecParser), new ParticleParser(pi5, pinConnsParser), new PartCloudParser(pi5), new MaterialParser(pi5), new SurfaceParser(pi5, exSpecParser, zoneParser), new ReactionParser(pi5), new HvacParser(pi5, pinConnsParser, ventParser), ctrlParser, propParser, new DeviceParser(pi5, pinConnsParser, propParser), spParser, new ObstParser(pi5, pinConnsParser, spParser), new HoleParser(pi5, pinConnsParser), ventParser, new ProfParser(pi5), new IsofParser(pi5), new Plot3dParser(pi5), new BoundaryParser(pi5, propParser), new SliceParser(pi5), new StatisticsParser(pi5), new PersParser(pi5), new EvssParser(pi5), new ExitParser(pi5), new EntrParser(pi5), new CorrParser(pi5), new DoorParser(pi5), new EvacParser(pi5), new EvhoParser(pi5), pinConnsParser, new PinConnFinisher(pi5, pinConnsParser, ctrlParser), new RampFinisher(pi5, pinConnsParser), new TailParser());
    }

    @Override
    protected FDSParsingInfo createParsingInfo(String filename, PyroMod writeMod, PyroMod readMod) {
        return new FDS5ParsingInfo(filename, writeMod, readMod);
    }

    @Override
    protected Map<String, FDSRecordSpec> getRecordSpecs() {
        return FDS5Const.getRecordSpecs();
    }

    @Override
    protected String getFinishRecType() {
        return "TAIL";
    }

    @Override
    protected void parseRecords(List<FDSParseRecord> records, String filename, FDSParsingInfo parsingInfo) throws IOException, FDSParseException {
        super.parseRecords(records, filename, parsingInfo);
        for (IPyroObject obj : parsingInfo.getParseResult().extractedObjs) {
            if (!(obj instanceof ISignalSink)) continue;
            Util.deleteNoops(((ISignalSink)obj).getInputPin());
        }
    }

    private static class TailParser
    implements IFDSRecordParser {
        private TailParser() {
        }

        @Override
        public void getRecordTypes(Set<String> types) {
            types.add("TAIL");
        }

        @Override
        public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        }

        @Override
        public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
        }

        @Override
        public void postProcess() {
        }
    }
}

