/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ExSpecParser
extends AFDS5Parser {
    private int d_specIx = 0;
    private final List<ExSpec> d_parsedSpecs = new ArrayList<ExSpec>();

    public ExSpecParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("SPEC");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    public ExSpec getSpec(int ix) {
        if (ix >= this.d_parsedSpecs.size()) {
            return null;
        }
        return this.d_parsedSpecs.get(ix);
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process SPEC record: ID missing"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpecList specs = this.getContainer().getExSpecList();
        String id = rec.getString("ID");
        boolean predef = ExSpecList.isPredefinedSpecies(id);
        if (specs.get(id) != null) {
            this.addWarning(rec, Intl.intl("Unable to process SPEC record: Duplicate ID"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpec spec = predef ? new ExSpec(ExSpecList.getPredefinedSpecies(id)) : new ExSpec(id, false);
        spec.setFYI(rec.getString("FYI", false));
        if (rec.contains("MASS_FRACTION_0")) {
            spec.setMassFraction0(rec.getDouble("MASS_FRACTION_0"));
        }
        if (predef) {
            this.addSpec(spec);
            return true;
        }
        if (rec.contains("MW")) {
            spec.setMolWt(rec.getUnitDouble("MW"));
        }
        UnitDouble mec = rec.getUnitDouble("MASS_EXTINCTION_COEFFICIENT", true);
        spec.setMassExtinctionCoeff(mec);
        if (!(!rec.contains("SIGMALJ") && !rec.contains("EPSILONKLJ") || rec.contains("SIGMALJ") && rec.contains("EPSILONKLJ"))) {
            this.addWarning(rec, Intl.intl("Incorrect specification of Leonard-Jones DNS parameters"), Intl.intl("DNS Parameters Ignored"));
        }
        if (rec.contains("SIGMALJ") && rec.contains("EPSILONKLJ")) {
            spec.setDNSLJ(rec.getUnitDouble("SIGMALJ"), rec.getUnitDouble("EPSILONKLJ"));
        }
        if (!(!rec.contains("VISCOSITY") && !rec.contains("CONDUCTIVITY") && !rec.contains("DIFFUSIVITY") || rec.contains("VISCOSITY") && rec.contains("CONDUCTIVITY") && rec.contains("DIFFUSIVITY"))) {
            this.addWarning(rec, Intl.intl("Incorrect specification of DNS parameters."), Intl.intl("DNS Parameters Ignored"));
        }
        if (rec.contains("VISCOSITY") && rec.contains("CONDUCTIVITY") && rec.contains("DIFFUSIVITY")) {
            spec.setDNSAlt(rec.getUnitDouble("VISCOSITY"), rec.getUnitDouble("CONDUCTIVITY"), rec.getUnitDouble("DIFFUSIVITY"));
        }
        if (rec.contains("ABSORBING")) {
            spec.setAbsorb(rec.getBoolean("ABSORBING"));
        }
        this.addSpec(spec);
        return true;
    }

    private void addSpec(ExSpec spec) {
        ExSpecList specs = this.getContainer().getExSpecList();
        specs.add(spec);
        this.flagObjectAdded(spec);
        this.d_parsedSpecs.add(spec);
    }
}

