/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.Evho;
import pyrosim.legacy_2012_1.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EvhoParser
extends AFDS5Parser {
    public EvhoParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process EVHO record: ID missing"), Intl.intl("EVHO Record Ignored"));
            return false;
        }
        EvhoList mgr = this.getContainer().getEvhoList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            int i = 1;
            String idBase = id;
            while (mgr.get(id = String.format("%s[%d]", idBase, i)) != null) {
            }
            this.addWarning(rec, Intl.intl("Invalid EVHO record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), idBase, id));
        }
        GridList grids = this.getContainer().getGridManager();
        PersList pers = this.getContainer().getPersList();
        EvacList evacs = this.getContainer().getEvacList();
        Evho obj = new Evho(id);
        obj.setProp("FYI", rec.get("FYI"));
        if (rec.contains("XB")) {
            FDSArray<UnitDouble> xbRaw = rec.getArray("XB", false);
            obj.setProp("XB", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        if (rec.contains("MESH_ID")) {
            obj.setProp("MESH_ID", grids.get(rec.getString("MESH_ID")));
        }
        if (rec.contains("PERS_ID")) {
            obj.setProp("PERS_ID", pers.get(rec.getString("PERS_ID")));
        }
        if (rec.contains("EVAC_ID")) {
            obj.setProp("EVAC_ID", evacs.get(rec.getString("EVAC_ID")));
        }
        mgr.add(obj);
        this.flagObjectAdded(obj);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("EVHO");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

