/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.Corr;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class CorrParser
extends AFDS5Parser {
    public CorrParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray<UnitDouble> xbRaw;
        String id;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process CORR record: ID missing"), Intl.intl("CORR Record Ignored"));
            return false;
        }
        CorrList mgr = this.getContainer().getCorrList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            int i = 1;
            String idBase = id;
            while (mgr.get(id = String.format("%s[%d]", idBase, i)) != null) {
            }
            this.addWarning(rec, Intl.intl("Invalid CORR record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), idBase, id));
        }
        Corr obj = new Corr(id);
        obj.setProp("FYI", rec.get("FYI"));
        if (rec.contains("MAX_HUMANS_INSIDE")) {
            obj.setProp("MAX_HUMANS_INSIDE", rec.getInteger("MAX_HUMANS_INSIDE"));
        }
        if (rec.contains("TO_NODE")) {
            String toNode = rec.getString("TO_NODE");
            NamedPyroObject objToNode = null;
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getDoorList().get(toNode);
            }
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getExitList().get(toNode);
            }
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getCorrList().get(toNode);
            }
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getEntrList().get(toNode);
            }
            if (objToNode != null) {
                obj.setProp("TO_NODE", objToNode);
            } else {
                this.addWarning(rec, String.format(Intl.intl("Invalid CORR record: Unknown TO_NODE \"%s\""), toNode), Intl.intl("TO_NODE record dropped."));
            }
        }
        if (rec.contains("XB")) {
            xbRaw = rec.getArray("XB", false);
            obj.setProp("XB1", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        if (rec.contains("XB1")) {
            xbRaw = rec.getArray("XB1", false);
            obj.setProp("XB1", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
            if (rec.contains("XB")) {
                this.addWarning(rec, Intl.intl("Invalid CORR record: Cannot define both XB and XB1"), Intl.intl("Ignoring value for XB"));
            }
        }
        if (rec.contains("XB2")) {
            xbRaw = rec.getArray("XB2", false);
            obj.setProp("XB2", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        if (rec.contains("FAC_SPEED")) {
            obj.setProp("FAC_SPEED", rec.getDouble("FAC_SPEED"));
        }
        if (rec.contains("EFF_LENGTH")) {
            obj.setProp("EFF_LENGTH", rec.getUnitDouble("EFF_LENGTH"));
        }
        mgr.add(obj);
        this.flagObjectAdded(obj);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("CORR");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

