/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.LinkedHashSet;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PropParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class BoundaryParser
extends AFDS5Parser {
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private final PropParser d_propParser;

    public BoundaryParser(FDS5ParsingInfo parsingInfo, PropParser propParser) {
        super(parsingInfo);
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("BNDF");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public void done() throws FDSRecordFormatException {
        if (this.d_measurements.isEmpty()) {
            return;
        }
        Boundaries boundaries = this.getContainer().getBoundaryOutput();
        this.d_measurements.addAll(boundaries.getQuantities());
        boundaries.setQuantities(this.d_measurements);
        this.flagObjectAdded(boundaries);
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        IQuantity measurement = this.parseQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 16, Intl.intl("BNDF record ignored"), true, false);
        if (measurement == null) {
            return false;
        }
        this.d_measurements.add(measurement);
        FDSParseRecord propRec = null;
        String propID = (String)rec.get("PROP_ID");
        if (propID != null && (propRec = this.d_propParser.getProp(propID)) == null) {
            this.addWarning(rec, String.format(Intl.intl("Could not find PROP record: %s"), propID), Intl.intl("Ignoring properties."));
        }
        if (propRec == null) {
            propRec = PropParser.getDefaultProp();
        }
        if (measurement.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            UnitDouble charVel = (UnitDouble)propRec.get("CHARACTERISTIC_VELOCITY", true);
            this.getContainer().getBoundaryOutput().setPressCoeffCharVel(charVel);
        } else if (measurement.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            UnitDouble gaugeTemp = (UnitDouble)propRec.get("GAUGE_TEMPERATURE", true);
            this.getContainer().getBoundaryOutput().setGaugeTemperature(gaugeTemp);
        }
        return true;
    }
}

