/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.EvacProps;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.Util;

public abstract class AFDSObjParser
extends AFDS5Parser {
    private int d_nextObjNum = 1;
    private Map<String, Object> d_compositesMap = new LinkedHashMap<String, Object>();

    public AFDSObjParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    protected String generateName(FDSParseRecord rec, String baseName) {
        String desc = rec.getComment();
        if (desc == null || desc.equals("")) {
            desc = String.format(Intl.intl("%1$s #%2$d"), baseName, this.d_nextObjNum++);
        }
        return desc;
    }

    protected void addObjects(String name, List<? extends IPyroObject> objs) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.addObject(objs.get(0));
        } else {
            ModelComposite group = new ModelComposite(name);
            group.addAll(objs);
            this.addObject(group);
        }
    }

    protected void addObject(IPyroObject obj) {
        String name = Util.getName(obj);
        Object existingEntry = this.d_compositesMap.get(name);
        if (existingEntry != null) {
            if (existingEntry instanceof List) {
                ((List)existingEntry).add(obj);
            } else {
                ArrayList<IPyroObject> list = new ArrayList<IPyroObject>();
                list.add((IPyroObject)existingEntry);
                list.add(obj);
                this.d_compositesMap.put(name, list);
            }
        } else {
            this.d_compositesMap.put(name, obj);
        }
    }

    @Override
    public void done() throws FDSRecordFormatException {
        ModelComposite root = this.getContainer().getObstructions();
        for (Map.Entry<String, Object> entry : this.d_compositesMap.entrySet()) {
            Object objVal = entry.getValue();
            if (objVal instanceof IPyroObject) {
                IPyroObject obj = (IPyroObject)objVal;
                root.add(obj);
                this.flagObjectAdded(obj);
                continue;
            }
            assert (objVal instanceof List);
            List objs = (List)objVal;
            ModelComposite comp = new ModelComposite(entry.getKey());
            comp.addAll(objs);
            root.add(comp);
            this.flagObjectAdded(comp);
        }
    }

    protected Surface getDefaultMat() {
        return this.getContainer().getSimParams().getMisc().getSurfDefault();
    }

    protected Surface getSurfaceSafe(FDSParseRecord rec, String surfaceName, IObjectFilter<Surface> filter) throws FDSRecordFormatException {
        if (surfaceName == null) {
            return this.getDefaultMat();
        }
        Surface mat = this.getParsingInfo().findObject(Surface.class, surfaceName);
        if (mat == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("The SURF, %s, does not exist in the model."), surfaceName));
        }
        if (filter.shouldFilter(mat)) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("The SURF, %1$s, cannot be applied to the %2$s."), surfaceName, rec.getType()));
        }
        return mat;
    }

    protected EvacProps parseEvac(FDSParseRecord rec, String evacKey, String meshIDKey) throws FDSRecordFormatException {
        int options = 0;
        Boolean evacFlag = rec.getBoolean("EVACUATION");
        if (evacFlag == null) {
            options = 0;
        } else if (evacFlag.booleanValue()) {
            options = 2;
        } else if (!evacFlag.booleanValue()) {
            options = 1;
        }
        Grid mesh = null;
        if (rec.contains("MESH_ID")) {
            mesh = this.findObject(rec, Grid.class, rec.getString("MESH_ID"), true);
        }
        return mesh == null && options == 0 ? EvacProps.DEFAULT : EvacProps.get(options, mesh);
    }
}

