/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class FDS5Colors {
    public static final String INVISIBLE = "INVISIBLE";
    private static final Map<String, Color> s_nameColorMap = new HashMap<String, Color>();
    private static final Map<Color, String> s_colorNameMap = new HashMap<Color, String>();

    public static Color getColor(String name) {
        return s_nameColorMap.get(name);
    }

    public static String getName(Color c) {
        return s_colorNameMap.get(c);
    }

    private static void readColors() {
        try {
            InputStream inStream = FDS5Colors.class.getResourceAsStream("fdscolors.csv");
            if (inStream == null) {
                System.err.println("fdscolors.csv resource could not be found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
            while (FDS5Colors.readColor(reader)) {
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean readColor(BufferedReader reader) throws Exception {
        String text = reader.readLine();
        if (text == null) {
            return false;
        }
        String[] tokens = text.split("\\,");
        if (tokens == null || tokens.length < 4) {
            return true;
        }
        String name = tokens[0];
        int r = Integer.parseInt(tokens[1]);
        int g = Integer.parseInt(tokens[2]);
        int b = Integer.parseInt(tokens[3]);
        int a = 255;
        if (tokens.length > 4) {
            a = Integer.parseInt(tokens[4]);
        }
        FDS5Colors.add(name, r, g, b, a);
        return true;
    }

    private static void add(String name, int r, int g, int b, int a) {
        Color c = new Color(r, g, b, a);
        s_nameColorMap.put(name, c);
        s_colorNameMap.put(c, name);
    }

    static {
        FDS5Colors.readColors();
    }
}

