/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.io.GE1File;
import pyrosim.legacy_2012_1.io.fds.FDSEnabledFilter;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.util.Util;
import thunderheadeng.io.CopyFile;

public abstract class FDSRenderer {
    private final PyroMod d_model;

    private Collection<IPyroObject> collectPyroObjects() {
        ArrayList<APyroObject> objs = new ArrayList<APyroObject>();
        objs.add(this.d_model.getSimParams());
        objs.addAll(this.d_model.getObstructions().flatten());
        objs.addAll(this.d_model.getGridManager().flatten());
        objs.addAll(this.d_model.getZoneLeakMgr().flatten());
        objs.addAll(Util.sort(this.d_model.getZoneMgr()));
        objs.addAll(Util.sort(this.d_model.getExSpecList()));
        Reaction activeReac = this.d_model.getReactions().getActiveReaction();
        if (activeReac != null) {
            objs.add(activeReac);
        }
        objs.addAll(this.d_model.getDevices().flatten());
        objs.add(this.d_model.getBoundaryOutput());
        objs.add(this.d_model.getPlot3d());
        objs.addAll(this.d_model.getIsofList().flatten());
        objs.addAll(this.d_model.getProfList().flatten());
        objs.addAll(this.d_model.getSlcfList().flatten());
        objs.addAll(this.d_model.getMsrStatMgr().flatten());
        objs.addAll(this.d_model.getHvacList().flatten());
        if (this.d_model.getFdsEvacEnabled()) {
            objs.addAll(this.d_model.getPersList().flatten());
            objs.addAll(this.d_model.getExitList().flatten());
            objs.addAll(this.d_model.getEvacList().flatten());
            objs.addAll(this.d_model.getEntrList().flatten());
            objs.addAll(this.d_model.getEvhoList().flatten());
            objs.addAll(this.d_model.getDoorList().flatten());
            objs.addAll(this.d_model.getCorrList().flatten());
            objs.addAll(this.d_model.getEvssList().flatten());
        }
        return new FilteredCollection<IPyroObject>(objs, IPyroObject.class, new FDSEnabledFilter());
    }

    public abstract void renderObjects(IFDSRecordRenderer var1, Collection<? extends IPyroObject> var2, DepSnapshot var3);

    protected abstract void renderFileForVersion(File var1, FDSRenderProps var2, Collection<? extends IPyroObject> var3, DepSnapshot var4) throws IOException;

    protected FDSRenderer(PyroMod model) {
        this.d_model = model;
    }

    protected PyroMod getModel() {
        return this.d_model;
    }

    public void renderFile(File file, FDSRenderProps props) throws IOException {
        this.renderFile(file, props, this.collectPyroObjects());
    }

    public void renderFile(File file, FDSRenderProps props, Collection<? extends IPyroObject> pyroObjects) throws IOException {
        DepSnapshot deps = FDSRenderer.collectDependedOns(pyroObjects);
        this.renderFileForVersion(file, props, pyroObjects, deps);
    }

    public void renderAllObjects(IFDSRecordRenderer props) {
        Collection<IPyroObject> allObjs = this.collectPyroObjects();
        this.renderObjects(props, allObjs);
    }

    public void renderObjects(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        DepSnapshot deps = FDSRenderer.collectDependedOns(objs);
        this.renderObjects(props, objs, deps);
    }

    public static DepSnapshot collectDependedOns(Collection<? extends IPyroObject> objs) {
        DepSnapshot dp = new DepSnapshot();
        for (IPyroObject iPyroObject : objs) {
            dp.takeSnapshot(iPyroObject);
        }
        dp.removeMappings(objs);
        return dp;
    }

    protected static boolean writeGE1(File outDir, String filename, PyroMod model) throws IOException {
        return GE1File.writeFile(new File(outDir, filename).getAbsolutePath(), model);
    }

    protected static void writeSmokeViewIni(File outDir, String filename, boolean writeGE1) throws IOException {
        PrintWriter iniWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(outDir, filename))));
        if (writeGE1) {
            FDSRenderer.writeSVINIPref(iniWriter, "BLOCKLOCATION", 5);
        }
        FDSRenderer.writeSVINIPref(iniWriter, "SHOWNORMALWHENSMOOTH", 1);
        FDSRenderer.writeSVINIPref(iniWriter, "SHOWALLTEXTURES", 1);
        iniWriter.close();
    }

    private static void writeSVINIPref(PrintWriter writer, String pref, Object value) {
        writer.println(pref);
        writer.println(value.toString());
    }

    protected static void copyTextures(TextureDB texDB, File outDir, Collection<? extends IPyroObject> objs) {
        TreeSet<String> needed = new TreeSet<String>();
        for (IPyroObject iPyroObject : objs) {
            TextureInfo ti;
            if (!(iPyroObject instanceof Surface) || (ti = ((Surface)iPyroObject).getTextureInfo()) == null) continue;
            String texname = ti.getTexID();
            needed.add(texname);
        }
        for (String string : needed) {
            assert (texDB.names().contains(string));
            TextureInfo texinfo = texDB.getDefaultInfo(string);
            if (texinfo == null) continue;
            String texID = texinfo.getTexID();
            Texture tex = texDB.getTexture(texID);
            File texFile = new File(outDir, texID);
            try {
                texFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            tex.getImage().save(texFile.getAbsolutePath());
        }
    }

    protected static void copyFile(File src, File dest) throws IOException {
        CopyFile.copy(src, dest);
    }

    public static String getProperCHID(String requestedCHID, int maxChidLength) {
        if (requestedCHID == null) {
            return null;
        }
        String newCHID = requestedCHID.trim();
        File temp = new File(newCHID);
        int extIndex = (newCHID = temp.getName()).lastIndexOf(46);
        if (extIndex >= 0) {
            newCHID = newCHID.substring(0, extIndex);
        }
        newCHID = newCHID.replace('.', '_');
        if ((newCHID = newCHID.replace(' ', '_')).length() > maxChidLength) {
            newCHID = newCHID.substring(0, maxChidLength);
        }
        return newCHID;
    }

    public static String getProperTitle(String requestedTitle, int maxTitleLength) {
        if (requestedTitle == null) {
            return null;
        }
        String newTitle = requestedTitle.trim();
        if (newTitle.length() > maxTitleLength) {
            newTitle = newTitle.substring(0, maxTitleLength);
        }
        return newTitle;
    }
}

