/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import pyrosim.Intl;

public class FDSParseException
extends Exception {
    private static final long serialVersionUID = -2497581122765534529L;

    public FDSParseException(String file, int lineNum, String message, StackTraceElement[] st) {
        this(file, lineNum, message);
        this.setStackTrace(st);
    }

    public FDSParseException(String file, int lineNum, String message) {
        super(FDSParseException.constructErrorMessage(file, lineNum, message));
    }

    private static String constructErrorMessage(String file, int lineNum, String message) {
        Object msg = "";
        if (file != null) {
            msg = (String)msg + String.format(Intl.intl("Error in file, %s."), file);
        }
        if (lineNum > 0) {
            if (((String)msg).length() > 0) {
                msg = (String)msg + "\n";
            }
            msg = (String)msg + String.format(Intl.intl("Line Number: %d"), lineNum);
        }
        if (message != null) {
            if (((String)msg).length() > 0) {
                msg = (String)msg + "\n\n";
            }
            msg = (String)msg + message;
        }
        return msg;
    }
}

