/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FDSArray<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] d_dimensions;
    private final int[] d_dimMults;
    private final Object d_array;

    public FDSArray(int[] dimensions) {
        this(null, dimensions);
    }

    public FDSArray(T initialVal, int[] dimensions) {
        assert (dimensions.length > 0);
        this.d_dimensions = dimensions;
        this.d_dimMults = new int[dimensions.length];
        for (int m = 0; m < this.d_dimMults.length; ++m) {
            int mult = 1;
            int multIx = dimensions.length - m - 1;
            for (int n = multIx - 1; n >= 0; --n) {
                mult *= dimensions[n];
            }
            this.d_dimMults[multIx] = mult;
        }
        int numElements = this.d_dimMults[dimensions.length - 1] * dimensions[dimensions.length - 1];
        this.d_array = Array.newInstance(Object.class, numElements);
        if (initialVal != null) {
            for (int m = 0; m < numElements; ++m) {
                Array.set(this.d_array, m, initialVal);
            }
        }
    }

    public FDSArray(Collection<? extends T> vals) {
        this(new int[]{vals.size()});
        int m = 0;
        for (T val : vals) {
            this.set(m++, val);
        }
    }

    public FDSArray(T ... vals) {
        this(new int[]{vals.length});
        for (int m = 0; m < vals.length; ++m) {
            this.set(m, vals[m]);
        }
    }

    public boolean isEmpty() {
        int len = Array.getLength(this.d_array);
        for (int m = 0; m < len; ++m) {
            if (Array.get(this.d_array, m) == null) continue;
            return false;
        }
        return true;
    }

    public boolean isFrontPacked() {
        if (Array.get(this.d_array, 0) == null) {
            return false;
        }
        int nonNullLimit = Math.min(this.getDimensions()[0], this.getTotalLength());
        int ix = 1;
        while (ix < nonNullLimit && Array.get(this.d_array, ix++) != null) {
        }
        while (ix < this.getTotalLength()) {
            if (Array.get(this.d_array, ix++) == null) continue;
            return false;
        }
        return true;
    }

    public List<T> getFrontPackedValsAsList() {
        if (!this.isFrontPacked()) {
            assert (false);
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> valsList = new ArrayList<Object>();
        int i = 0;
        while (i < this.getDimensions()[0] && Array.get(this.d_array, i) != null) {
            valsList.add(Array.get(this.d_array, i++));
        }
        return valsList;
    }

    public T[] toFlatArray(T[] arr) {
        for (int m = 0; m < this.getTotalLength(); ++m) {
            arr[m] = Array.get(this.d_array, m);
        }
        return arr;
    }

    public int[] getDimensions() {
        return this.d_dimensions;
    }

    public void set(T val, int[] ixes) {
        assert (ixes.length == this.d_dimensions.length);
        assert (this.isIndexValid(ixes));
        int ix = this.getGlobalIx(ixes);
        Array.set(this.d_array, ix, val);
    }

    public T get(int ... ixes) {
        assert (ixes.length == this.d_dimensions.length);
        assert (this.isIndexValid(ixes));
        int ix = this.getGlobalIx(ixes);
        return (T)Array.get(this.d_array, ix);
    }

    public void set(int beginIx, T ... vals) {
        for (int m = 0; m < vals.length; ++m) {
            Array.set(this.d_array, m + beginIx, vals[m]);
        }
    }

    public void set(int beginIx, List<? extends T> vals) {
        for (int m = 0; m < vals.size(); ++m) {
            Array.set(this.d_array, m + beginIx, vals.get(m));
        }
    }

    public int getTotalLength() {
        return Array.getLength(this.d_array);
    }

    public boolean isIndexValid(int ... ixes) {
        int gix = this.getGlobalIx(ixes);
        return gix >= 0 && gix < Array.getLength(this.d_array);
    }

    private int getGlobalIx(int ... subixes) {
        assert (subixes.length == this.d_dimensions.length);
        int ix = 0;
        for (int m = 0; m < subixes.length; ++m) {
            ix += subixes[m] * this.d_dimMults[m];
        }
        return ix;
    }

    public Object getBaseArray() {
        return this.d_array;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FDSArray)) {
            return false;
        }
        FDSArray arr = (FDSArray)obj;
        if (!Arrays.equals(this.d_dimensions, arr.d_dimensions)) {
            return false;
        }
        for (int m = 0; m < this.getTotalLength(); ++m) {
            boolean equal;
            Object o1 = Array.get(this.d_array, m);
            Object o2 = Array.get(arr.d_array, m);
            boolean bl = o1 == null ? o2 == null : (equal = o1.equals(o2));
            if (equal) continue;
            return false;
        }
        return true;
    }

    public boolean containsNonNull() {
        int len = Array.getLength(this.d_array);
        for (int m = 0; m < len; ++m) {
            Object val = Array.get(this.d_array, m);
            if (val == null) continue;
            return true;
        }
        return false;
    }
}

