/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.geom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;

public class TexCoordGenerator
implements ITexCoordGenerator,
Serializable {
    static final long serialVersionUID = 1L;
    private final Point3d d_texOrigin;

    public TexCoordGenerator(IGeom geom, TexOrigin origin) {
        this(origin != null ? origin.getWorld(geom).getValue(Geometry.LU) : GeomConstants.PNT3D_ORIGIN);
    }

    public TexCoordGenerator(Point3d texOrigin) {
        this.d_texOrigin = texOrigin;
    }

    @Override
    public IElemSource<Point2d> fromLegacy(LegacyDictionary_2012_1 dict) {
        PlanarCoordMapper mapper = pyrosim.geom.TexCoordGenerator.newGenerator(this.d_texOrigin);
        return mapper.equals(pyrosim.geom.TexCoordGenerator.DEFAULT_OBJ) ? pyrosim.geom.TexCoordGenerator.DEFAULT_OBJ : mapper;
    }

    @Override
    public void generate(int primIx, IPolygon face, IPrimProps props, List<Point2d> texuv) {
        Surface surf = (Surface)props.getMaterial();
        TextureInfo ti = surf.getTextureInfo();
        double iwidth = 1.0 / ti.getWidth().getValue(Geometry.LU);
        double iheight = 1.0 / ti.getHeight().getValue(Geometry.LU);
        Vector3d[] localVecs = TexCoordGenerator.generateLocalVecs(face.getNormal());
        int numLoops = face.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = face.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                Point3d p = face.getPoint(m, n);
                Point2d p2d = TexCoordGenerator.generateTexUV(this.d_texOrigin, iwidth, iheight, localVecs[0], localVecs[1], p);
                texuv.add(p2d);
            }
        }
    }

    @Override
    public void generate(int primIx, IFace face, IPrimProps props, Mesh tmesh, List<Point2d> texuv) {
        assert (tmesh.primtype == 2);
        Point3d[] tempPoints = new Point3d[3];
        List<Point3d> pList = Arrays.asList(tempPoints);
        Vector3d avgNormal = new Vector3d(0.0, 0.0, 0.0);
        int m = 0;
        while (m < tmesh.indices.length) {
            tempPoints[0] = tmesh.vertices[tmesh.indices[m++]];
            tempPoints[1] = tmesh.vertices[tmesh.indices[m++]];
            tempPoints[2] = tmesh.vertices[tmesh.indices[m++]];
            Vector3d tnorm = Util3D.simplePolygonNormal(pList);
            if (tnorm == null) continue;
            avgNormal.add(tnorm);
        }
        double len = avgNormal.length();
        if (len > 0.0) {
            int numPolys = tmesh.getNumPrims(1);
            avgNormal.scale(1 / numPolys);
            avgNormal.normalize();
        } else {
            avgNormal = GeomConstants.VEC3D_ZPOS;
        }
        Vector3d[] localVecs = TexCoordGenerator.generateLocalVecs(avgNormal);
        Surface surf = (Surface)props.getMaterial();
        TextureInfo ti = surf.getTextureInfo();
        double iwidth = 1.0 / ti.getWidth().getValue(Geometry.LU);
        double iheight = 1.0 / ti.getHeight().getValue(Geometry.LU);
        for (Point3d p : tmesh.vertices) {
            Point2d p2d = TexCoordGenerator.generateTexUV(this.d_texOrigin, iwidth, iheight, localVecs[0], localVecs[1], p);
            texuv.add(p2d);
        }
    }

    private static Point2d generateTexUV(Point3d origin, double iwidth, double iheight, Vector3d tangent, Vector3d bitangent, Point3d p) {
        double dx = p.x - origin.x;
        double dy = p.y - origin.y;
        double dz = p.z - origin.z;
        double lx = tangent.x * dx + tangent.y * dy + tangent.z * dz;
        double ly = bitangent.x * dx + bitangent.y * dy + bitangent.z * dz;
        return new Point2d(lx * iwidth, ly * iheight);
    }

    private static Vector3d[] generateLocalVecs(Vector3d normal) {
        Vector3d tangent;
        if (normal.x == 0.0 && normal.y == 0.0) {
            tangent = new Vector3d(1.0, 0.0, 0.0);
        } else {
            tangent = new Vector3d(-normal.y, normal.x, 0.0);
            tangent.normalize();
        }
        Vector3d bitangent = Util3D.cross(normal, tangent);
        bitangent.normalize();
        return new Vector3d[]{tangent, bitangent};
    }
}

