/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.texture;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.gui.IDomainObject;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;

public class TextureDB
implements IDomainObject<PyroMod>,
Serializable {
    private static final long serialVersionUID = 1L;
    private PyroMod d_domain;
    private Map<String, TextureInfo> d_defaults = new HashMap<String, TextureInfo>();
    private Map<String, Texture> d_textures = new HashMap<String, Texture>();

    @Override
    public void setDomain(PyroMod domain) {
        this.d_domain = domain;
    }

    @Override
    public PyroMod getDomain() {
        return this.d_domain;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ArrayList<Texture> inUse = new ArrayList<Texture>();
        ArrayList<TextureInfo> tis = new ArrayList<TextureInfo>();
        if (this.d_domain != null) {
            for (Texture tex : this.d_textures.values()) {
                if (!tex.usedIn(this.d_domain)) continue;
                inUse.add(tex);
                tis.add(this.d_defaults.get(tex.getImageID()));
            }
        }
        int version = 2;
        oos.writeInt(2);
        oos.writeObject(inUse);
        oos.writeObject(tis);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int version = ois.readInt();
        this.d_textures = new HashMap<String, Texture>();
        this.d_defaults = new HashMap<String, TextureInfo>();
        if (version < 2) {
            List inUse = (List)ois.readObject();
            for (TextureData td : inUse) {
                Image newImg;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                if (!ImageIO.write((RenderedImage)td.img, "jpg", os) || (newImg = Image.load(td.id, os.toByteArray())) == null) continue;
                this.d_textures.put(td.id, new Texture(td.id, newImg));
            }
        } else {
            List inUse = (List)ois.readObject();
            for (Texture tex : inUse) {
                this.d_textures.put(tex.getImageID(), tex);
            }
            List tis = (List)ois.readObject();
            for (TextureInfo ti : tis) {
                this.d_defaults.put(ti.getTexID(), ti);
            }
        }
    }

    public Set<String> names() {
        return this.d_textures.keySet();
    }

    public Texture getTexture(String id) {
        return this.d_textures.get(id);
    }

    public void setTexture(String id, Texture tex) {
        this.d_textures.put(id, tex);
    }

    public void removeTexture(String id) {
        this.d_textures.remove(id);
    }

    public void setDefaultInfo(String texname, TextureInfo defaultInfo) {
        this.d_defaults.put(texname, defaultInfo);
    }

    public TextureInfo getDefaultInfo(String texname) {
        return this.d_defaults.get(texname);
    }

    public void removeDefaultInfo(String texname) {
        this.d_defaults.remove(texname);
    }

    @Deprecated
    private static class TextureData
    implements Serializable {
        static final long serialVersionUID = 6282794853364214105L;
        private static final int VERSION = 1;
        public String id;
        public BufferedImage img;

        public TextureData(String id, BufferedImage img) {
            this.id = id;
            this.img = img;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeInt(1);
            oos.writeObject(this.id);
            if (this.img != null) {
                ImageIO.write((RenderedImage)this.img, "jpg", oos);
            } else {
                oos.writeObject(null);
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.readInt();
            this.id = (String)ois.readObject();
            this.img = ImageIO.read(ois);
        }
    }
}

