/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.DeletePreserveTask;
import pyrosim.legacy_2012_1.domain.tasks.DeleteTask;
import pyrosim.legacy_2012_1.domain.tasks.ReplacePreserveTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.Util;

public class Tasks {
    public static Task replace(List<? extends IPyroObject> objects, List<? extends IPyroObject> replacements, boolean preserveIndexes) {
        if (objects.isEmpty()) {
            return EmptyTask.INSTANCE;
        }
        assert (objects.size() == replacements.size());
        if (!preserveIndexes) {
            CompositeTask task = new CompositeTask(objects.get(0).getDomain());
            task.addTask(Tasks.delete(objects));
            for (int m = 0; m < objects.size(); ++m) {
                Composite parent = (Composite)objects.get(m).getParent();
                task.addTask(new AddTask(parent, new IPyroObject[]{replacements.get(m)}));
            }
            return task;
        }
        return new ReplacePreserveTask(objects, replacements);
    }

    public static Task replace(IPyroObject object, IPyroObject replacement, boolean preserveIndex) {
        return Tasks.replace(Arrays.asList(object), Arrays.asList(replacement), preserveIndex);
    }

    public static Task delete(IPyroObject ... objs) {
        return Tasks.delete(Arrays.asList(objs));
    }

    public static Task delete(Collection<? extends IPyroObject> objs) {
        boolean noPreserve;
        Collection<IPyroObject> preserveObjs = Util.filter(objs, IPyroObject.class, new PreserveIxFilter(true));
        Collection<IPyroObject> noPreserveObjs = Util.filter(objs, IPyroObject.class, new PreserveIxFilter(false));
        boolean preserve = !preserveObjs.isEmpty();
        boolean bl = noPreserve = !noPreserveObjs.isEmpty();
        if (preserve && noPreserve) {
            CompositeTask task = new CompositeTask(objs.iterator().next().getDomain());
            task.addTask(new DeletePreserveTask(preserveObjs));
            task.addTask(new DeleteTask(noPreserveObjs));
            return task;
        }
        if (preserve) {
            return new DeletePreserveTask(objs);
        }
        if (noPreserve) {
            return new DeleteTask(objs);
        }
        return EmptyTask.INSTANCE;
    }

    private static class PreserveIxFilter<T extends IPyroObject>
    implements IObjectFilter<T> {
        private final boolean d_preserve;

        public PreserveIxFilter(boolean preserve) {
            this.d_preserve = preserve;
        }

        @Override
        public boolean shouldFilter(T o) {
            IPyroObject parent = o.getParent();
            assert (parent != null);
            return this.d_preserve != TVEntryPoints.ep(parent).preserveIndexOnDelete((PyroMod)o.getDomain(), parent, o);
        }
    }
}

