/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.TransformTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class ScaleTask
extends TransformTask {
    private final Point3d d_base;
    private final Tuple3d d_scale;

    public ScaleTask(PyroMod mediator, Collection<? extends IPyroObject> objects, int n, UnitPoint3D base, Tuple3d scale) {
        super(mediator, objects, n);
        this.d_base = base.getPoint3dValue(Geometry.LU);
        this.d_scale = new Vector3d(scale);
    }

    @Override
    public Matrix4d getXFormForIteration(int i) {
        double scalex = Math.pow(this.d_scale.x, i);
        double scaley = Math.pow(this.d_scale.y, i);
        double scalez = Math.pow(this.d_scale.z, i);
        Matrix4d matrix = Util.translateMat(this.d_base.x, this.d_base.y, this.d_base.z);
        matrix.mul(Util.scaleMat(scalex, scaley, scalez));
        matrix.mul(Util.translateMat(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return matrix;
    }

    private static class Transform {
        private Tuple3d d_scale;
        private Matrix4d d_matrix;

        private Transform() {
        }
    }
}

