/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.geom.Hole;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.tasks.InsertTask;
import pyrosim.legacy_2012_1.domain.tasks.SelectTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.util.Util;

public class GroupGeomTask
extends CompositeTask<PyroMod> {
    public GroupGeomTask(PyroMod mediator, Collection<? extends IModelObj> objs, ConvertType convertType) {
        super(mediator);
        IModelObj result = convertType == ConvertType.GENERIC ? this.merge(Util.filter(objs, GenericGeomSrc.class)) : this.merge(Util.filter(objs, FDSObject.class), convertType);
        Pair<ModelComposite, Integer> insert = GroupGeomTask.getInsertInfo(objs);
        SelectTask task = new SelectTask(mediator, result);
        task.addTask(Tasks.delete(objs));
        task.addTask(new InsertTask((Composite)insert.v1, ((Integer)insert.v2).intValue(), new IPyroObject[]{result}));
        this.addTask(task);
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<ModelComposite, Integer> getInsertInfo(Collection<? extends IModelObj> objs) {
        IPyroObject parent = Hierarchy.getCommonParent(objs);
        assert (parent instanceof ModelComposite);
        ModelComposite cparent = (ModelComposite)parent;
        IdentityHashMap<IPyroObject, Integer> ixMap = new IdentityHashMap<IPyroObject, Integer>();
        int ix = 0;
        for (IPyroObject member : cparent.getMembers()) {
            ixMap.put(member, ix++);
        }
        int index = cparent.getMembers().size();
        for (IPyroObject iPyroObject : objs) {
            void var7_8;
            IPyroObject oparent = iPyroObject.getParent();
            while (oparent != null && oparent != cparent) {
                IPyroObject iPyroObject2 = oparent;
                oparent = iPyroObject2.getParent();
            }
            assert (oparent == cparent);
            assert (ixMap.containsKey(var7_8));
            int oix = (Integer)ixMap.get(var7_8);
            if (oix >= index) continue;
            index = oix;
        }
        return new Pair<ModelComposite, Integer>(cparent, index);
    }

    private PyroMod getDomain() {
        return (PyroMod)this.getDomains().iterator().next();
    }

    private GenericGeomSrc merge(Collection<? extends GenericGeomSrc> objs) {
        PropsBuilder props = new PropsBuilder();
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        for (GenericGeomSrc genericGeomSrc : objs) {
            IGeom geom = genericGeomSrc.getGeom();
            IPropsSrc objProps = genericGeomSrc.getDisplayProps();
            props.add(objProps, geom.getNumPrims(7), true);
            geoms.add(geom);
        }
        return new GenericGeomSrc(objs.iterator().next().getName(), pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.group(geoms), objs.iterator().next().getTexCoordGen(), props.finalizeProps());
    }

    /*
     * WARNING - void declaration
     */
    private FDSObject merge(Collection<? extends FDSObject> objs, ConvertType convertType) {
        void var8_11;
        Surface inert = (Surface)this.getDomain().getSurfaceMgr().get(PredefSurf.INERT.name());
        ArrayList<Surface> surfs = new ArrayList<Surface>(objs.size());
        ArrayList<Color> colors = new ArrayList<Color>(objs.size());
        ArrayList<IGeom> geoms = new ArrayList<IGeom>(objs.size());
        for (FDSObject fDSObject : objs) {
            Surface[] subSurfs;
            Color[] subColors = GroupGeomTask.flatten(Color.class, fDSObject.getColors(), fDSObject.getGeom().getNumPrims(7));
            if (fDSObject instanceof IObstruction) {
                subSurfs = GroupGeomTask.flatten(Surface.class, ((IObstruction)fDSObject).getSurfaces(), fDSObject.getGeom().getNumPrims(1));
            } else {
                subSurfs = new Surface[fDSObject.getGeom().getNumPrims(1)];
                for (int m = 0; m < subSurfs.length; ++m) {
                    subSurfs[m] = inert;
                }
            }
            surfs.addAll(Arrays.asList(subSurfs));
            colors.addAll(Arrays.asList(subColors));
            geoms.add(fDSObject.getGeom());
        }
        Color[] colorsArr = colors.toArray(new Color[colors.size()]);
        Surface[] surfaceArray = surfs.toArray(new Surface[surfs.size()]);
        if (GeomUtil.isUniform(colorsArr)) {
            colorsArr = new Color[]{colorsArr[0]};
        }
        if (GeomUtil.isUniform(surfaceArray)) {
            Surface[] surfaceArray2 = new Surface[]{surfaceArray[0]};
        }
        GeomGroup newGeom = new GeomGroup(geoms);
        return convertType == ConvertType.OBSTRUCTION ? GroupGeomTask.convertToObst(objs, newGeom, colorsArr, (Surface[])var8_11) : GroupGeomTask.convertToHole(objs, newGeom, colorsArr);
    }

    private static IObstruction convertToObst(Collection<? extends FDSObject> objs, IGeom geom, Color[] colors, Surface[] surfs) {
        IObstruction result;
        FilteredCollection<IObstruction> obsts = new FilteredCollection<IObstruction>(objs, IObstruction.class);
        if (!obsts.isEmpty()) {
            IObstruction baseObst = (IObstruction)obsts.iterator().next();
            result = (IObstruction)baseObst.clone();
            result.setGeom(geom, true);
            result.setSurfaces(surfs);
        } else {
            result = new Obstruction(Intl.intl("Obstruction"), geom, surfs);
        }
        result.setColors(colors);
        return result;
    }

    private static IHole convertToHole(Collection<? extends FDSObject> objs, IGeom geom, Color[] colors) {
        IHole result;
        FilteredCollection<IHole> holes = new FilteredCollection<IHole>(objs, IHole.class);
        if (!holes.isEmpty()) {
            IHole baseHole = (IHole)holes.iterator().next();
            result = (IHole)baseHole.clone();
            result.setGeom(geom, true);
        } else {
            result = new Hole(Intl.intl("Hole"), geom);
        }
        result.setColors(colors);
        return result;
    }

    private static <T> T[] flatten(Class<T> clazz, T[] baseArr, int count) {
        if (baseArr.length == 1 && count != 1) {
            Object[] newArr = (Object[])Array.newInstance(clazz, count);
            for (int m = 0; m < count; ++m) {
                newArr[m] = baseArr[0];
            }
            return newArr;
        }
        assert (baseArr.length == count);
        return baseArr;
    }

    public static enum ConvertType {
        HOLE,
        OBSTRUCTION,
        GENERIC;

    }
}

