/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;

public class DeleteTask
extends AUndoableTask {
    private IPyroObject[] d_deletions;

    public DeleteTask(IPyroObject ... objs) {
        this(Arrays.asList(objs));
    }

    public DeleteTask(Collection<? extends IPyroObject> objs) {
        this.d_deletions = new IPyroObject[objs.size() * 2];
        int i = 0;
        for (IPyroObject iPyroObject : objs) {
            this.d_deletions[i++] = iPyroObject.getParent();
            this.d_deletions[i++] = iPyroObject;
        }
    }

    private PyroMod getDomain() {
        return this.d_deletions.length == 0 ? null : (PyroMod)this.d_deletions[0].getDomain();
    }

    private void pauseUpdates() {
        PyroMod domain = this.getDomain();
        if (domain != null) {
            domain.pauseUpdates();
        }
    }

    private void resumeUpdates() {
        PyroMod domain = this.getDomain();
        if (domain != null) {
            domain.resumeUpdates();
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        int m = this.d_deletions.length - 1;
        while (m >= 0) {
            IPyroObject obj = this.d_deletions[m--];
            Composite parent = (Composite)this.d_deletions[m--];
            boolean added = parent.add(obj);
            assert (added);
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        int m = 0;
        while (m < this.d_deletions.length) {
            Composite parent = (Composite)this.d_deletions[m++];
            IPyroObject obj = this.d_deletions[m++];
            boolean removed = parent.remove(obj);
            assert (removed);
        }
        this.resumeUpdates();
    }
}

