/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;

public class AutoRenameTask<V extends INamed>
extends AUndoableTask {
    private final Composite<? super V> d_mgr;
    private final INamed[] d_objects;
    private String[] d_names;

    public AutoRenameTask(Composite<? super V> mgr, V ... objs) {
        this(mgr, (Collection<? super V>)Arrays.asList(objs));
    }

    public AutoRenameTask(Composite<? super V> mgr, Collection<? extends V> objs) {
        this.d_mgr = mgr;
        this.d_objects = objs.toArray(new INamed[objs.size()]);
    }

    @Override
    public void undo() {
        this.rename();
    }

    @Override
    public void run() {
        if (this.d_names == null) {
            HashSet<String> forbiddenNames = new HashSet<String>();
            for (V obj : this.d_mgr.flatten()) {
                if (!(obj instanceof INamed)) continue;
                forbiddenNames.add(((INamed)obj).getName());
            }
            this.d_names = new String[this.d_objects.length];
            for (int m = 0; m < this.d_objects.length; ++m) {
                String newName = Util.getUniqueName(this.d_mgr, this.d_objects[m], forbiddenNames);
                forbiddenNames.add(newName);
                this.d_names[m] = newName;
            }
        }
        this.rename();
    }

    private void rename() {
        this.d_mgr.pauseUpdates();
        for (int m = 0; m < this.d_objects.length; ++m) {
            String oldName = this.d_objects[m].getName();
            String newName = this.d_names[m];
            this.d_names[m] = oldName;
            this.d_objects[m].setName(newName);
        }
        this.d_mgr.resumeUpdates();
    }
}

