/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;

public class AddTask<V extends IPyroObject>
extends AUndoableTask {
    private final Object d_objs;
    private final Composite<V> d_parent;

    public AddTask(Composite<V> parent, V ... objs) {
        this(parent, (Collection<V>)Arrays.asList(objs));
    }

    public AddTask(Composite<V> parent, Collection<? extends V> objs) {
        this.d_parent = parent;
        this.d_objs = objs.size() == 1 ? objs.iterator().next() : new ArrayList<V>(objs);
    }

    public List<? extends V> getObjects() {
        return this.d_objs instanceof ArrayList ? (ArrayList)this.d_objs : Arrays.asList((IPyroObject)this.d_objs);
    }

    protected PyroMod getDomain() {
        return (PyroMod)this.d_parent.getDomain();
    }

    protected Composite<V> getParent() {
        return this.d_parent;
    }

    protected void pauseUpdates() {
        PyroMod domain = this.getDomain();
        if (domain != null) {
            domain.pauseUpdates();
        }
    }

    protected void resumeUpdates() {
        PyroMod domain = this.getDomain();
        if (domain != null) {
            domain.resumeUpdates();
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        List<V> objs = this.getObjects();
        for (int m = objs.size() - 1; m >= 0; --m) {
            this.remove(this.d_parent, (IPyroObject)objs.get(m));
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        for (IPyroObject obj : this.getObjects()) {
            this.add(this.d_parent, obj);
        }
        this.resumeUpdates();
    }

    protected void remove(Composite<V> parent, V obj) {
        this.d_parent.remove((IPyroObject)obj);
    }

    protected void add(Composite<V> parent, V obj) {
        boolean added = this.d_parent.add((IPyroObject)obj);
        assert (added);
    }
}

