/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.signals;

import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.signals.AOneInPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.Util;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.unitsystem.UnitSystem;

public abstract class AOneDoubleInPin
extends AOneInPin
implements IDoubleInPin {
    static final long serialVersionUID = 1L;

    public AOneDoubleInPin(IControl controller) {
        super(controller);
    }

    @Override
    public boolean isCompatible(IOutPin pin2) {
        return pin2 instanceof IDoubleOutPin;
    }

    @Override
    public void connect(IOutPin pin2) {
        assert (pin2 instanceof IDoubleOutPin);
        Unit newUnit = AOneDoubleInPin.getSampleUnit(pin2);
        Set<? extends IOutPin> connPins = this.getConnections();
        if (!connPins.isEmpty()) {
            Unit oldUnit = AOneDoubleInPin.getSampleUnit(connPins.iterator().next());
            if (!Util.areCompatible(newUnit, oldUnit)) {
                this.updateInputUnit(newUnit);
            }
        } else {
            this.updateInputUnit(newUnit);
        }
        super.connect(pin2);
    }

    private static Unit getSampleUnit(IOutPin pin) {
        assert (pin instanceof IDoubleOutPin);
        SIUS us = SIUS.getInstance();
        IDoubleOutPin newPin = (IDoubleOutPin)pin;
        int newUnitType = newPin.getUnitType();
        return ((UnitSystem)us).getUnit(newUnitType);
    }

    @Override
    public void changeInputUnits(UnitSystem us) {
        Set<? extends IOutPin> outPins = this.getConnections();
        if (!outPins.isEmpty()) {
            IDoubleOutPin outPin = (IDoubleOutPin)outPins.iterator().next();
            int unitType = outPin.getUnitType();
            Unit newUnit = us.getUnit(unitType);
            this.changeInputUnit(newUnit);
        }
    }

    protected abstract void changeInputUnit(Unit var1);

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AOneDoubleInPin && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 10065972;
    }
}

