/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.rasterization;

import java.awt.Color;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ObstFragGenerator
implements IFragGenerator<IObstruction> {
    private final RasterizationOptions d_options;
    public final IObstruction src;

    public ObstFragGenerator(IObstruction src, RasterizationOptions options) {
        this.src = src;
        this.d_options = options;
    }

    public int hashCode() {
        return this.src.getSetOptions() + theUtil.hashCode(this.src.isVisible()) + theUtil.hashCode(this.src.isEnabled()) + System.identityHashCode(this.getSignalSource(this.src)) + this.src.getTextureOrigin().hashCode() + theUtil.hashCode(this.src.getBulkDensity()) + this.src.getEvac().hashCode() + (this.d_options.ignoreMergeNames ? 0 : this.src.getName().hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObstFragGenerator)) {
            return false;
        }
        ObstFragGenerator hash = (ObstFragGenerator)obj;
        return this.src.getSetOptions() == hash.src.getSetOptions() && this.src.isVisible() == hash.src.isVisible() && this.src.isEnabled() == hash.src.isEnabled() && this.getSignalSource(this.src) == this.getSignalSource(hash.src) && this.src.getTextureOrigin().equals(hash.src.getTextureOrigin()) && theUtil.equal(this.src.getBulkDensity(), hash.src.getBulkDensity()) && this.src.getEvac().equals(hash.src.getEvac()) && (this.d_options.ignoreMergeNames || this.src.getName().equals(hash.src.getName()));
    }

    @Override
    public IGeom transformGeom(IGeom geom) {
        return geom;
    }

    public IObstruction getOriginatingObj() {
        return this.src;
    }

    public int getOptions() {
        return this.src.getSetOptions();
    }

    public TexOrigin getTextureOrigin() {
        return this.src.getTextureOrigin();
    }

    public IOutPin getSignalSource() {
        return this.getSignalSource(this.src);
    }

    private IOutPin getSignalSource(ISignalSink sink) {
        Set<? extends IOutPin> srcs = sink.getInputPin().getConnections();
        return srcs.isEmpty() ? null : srcs.iterator().next();
    }

    @Override
    public IObstruction generateFrag(IGeom geom, FaceProps[] faceProps) {
        Surface[] surfs;
        Color[] colors;
        if (faceProps.length == 1) {
            colors = new Color[]{faceProps[0].color};
            surfs = new Surface[]{faceProps[0].surface};
        } else {
            int numFaces = geom.getNumPrims(1);
            assert (faceProps.length == numFaces);
            colors = new Color[numFaces];
            surfs = new Surface[numFaces];
            for (int m = 0; m < numFaces; ++m) {
                FaceProps prop = faceProps[m];
                surfs[m] = prop.surface;
                colors[m] = prop.color;
            }
            if (GeomUtil.isUniform(surfs)) {
                surfs = new Surface[]{surfs[0]};
            }
            if (GeomUtil.isUniform(colors)) {
                colors = new Color[]{colors[0]};
            }
        }
        Obstruction ab = new Obstruction(this.src.getName(), geom, surfs);
        ab.setColors(colors);
        ab.setVisible(this.src.isVisible());
        ab.setOptions(this.src.getSetOptions(), true);
        ab.setOptions(~this.src.getSetOptions(), false);
        ab.setTextureOrigin(this.src.getTextureOrigin());
        IOutPin signalSrc = this.getSignalSource();
        if (signalSrc != null) {
            ab.getInputPin().connect(signalSrc);
        }
        ab.setBulkDensity(this.src.getBulkDensity());
        ab.setEvac(this.src.getEvac());
        return ab;
    }

    @Override
    public IPrimProps generateDisplayProps(FaceProps fprops) {
        return new IPrimProps.Face(fprops.color, fprops.surface, true);
    }
}

