/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class SizeDistribution
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_medianDiameter;
    public final Type d_type;

    public SizeDistribution() {
        this(new UnitDouble(500.0, SI.MICRO(SI.METER)), new RosinRammler());
    }

    public SizeDistribution(UnitDouble medianDiameter, Type type) {
        this.d_medianDiameter = medianDiameter;
        this.d_type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SizeDistribution)) {
            return false;
        }
        SizeDistribution dist = (SizeDistribution)obj;
        return this.d_medianDiameter.equals(dist.d_medianDiameter) && this.d_type.equals(dist.d_type);
    }

    public int hashCode() {
        return 1665355757 + this.d_medianDiameter.hashCode() + this.d_type.hashCode();
    }

    public static class RosinRammler
    implements Type {
        static final long serialVersionUID = 1L;
        public final double d_gammaD;
        public final UnitDouble d_minDiameter;
        public final UnitDouble d_maxDiameter;
        public final Double d_sigma;

        public RosinRammler() {
            this(2.4);
        }

        public RosinRammler(double gammaD) {
            this(gammaD, new UnitDouble(20.0, SI.MICRO(SI.METER)), new UnitDouble(Double.POSITIVE_INFINITY, SI.MICRO(SI.METER)), null);
        }

        public RosinRammler(double gammaD, UnitDouble minDiameter, UnitDouble maxDiameter, Double sigma) {
            this.d_gammaD = gammaD;
            this.d_minDiameter = minDiameter;
            this.d_maxDiameter = maxDiameter;
            this.d_sigma = sigma;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RosinRammler)) {
                return false;
            }
            RosinRammler type = (RosinRammler)obj;
            return this.d_gammaD == type.d_gammaD && this.d_minDiameter.equals(type.d_minDiameter) && this.d_maxDiameter.equals(type.d_maxDiameter) && theUtil.equal(this.d_sigma, type.d_sigma);
        }

        public int hashCode() {
            return 593801012 + theUtil.hashCode(this.d_gammaD) + this.d_minDiameter.hashCode() + this.d_maxDiameter.hashCode() + theUtil.hashCode(this.d_sigma);
        }
    }

    public static interface Type
    extends Serializable {
    }

    public static class Constant
    implements Type {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Constant;
        }

        public int hashCode() {
            return -2110521542;
        }
    }
}

