/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Pyrolysis
implements Serializable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_meltingTemp;
    private boolean d_evaporate;
    public final UnitDouble d_vapTemp;
    public final UnitDouble d_heatOfVap;
    private ExSpec d_vapSpec;

    public Pyrolysis() {
        this(new UnitDouble(0.0, SI.CELSIUS), true, new UnitDouble(100.0, SI.CELSIUS), SIUS.newud(2259.0, 46), null);
    }

    protected Pyrolysis(UnitDouble meltingTemp, boolean evaporate, UnitDouble vapTemp, UnitDouble heatOfVap, ExSpec vapSpecies) {
        this.d_meltingTemp = meltingTemp;
        this.d_evaporate = evaporate;
        this.d_vapTemp = vapTemp;
        this.d_heatOfVap = heatOfVap;
        this.d_vapSpec = vapSpecies;
        assert (!evaporate || vapTemp != null && heatOfVap != null) : "If evaporation is turned on, the vaporazation temperature and heat of vaporazation must be specified";
    }

    public static Pyrolysis evapOff(UnitDouble meltingTemp) {
        return new Pyrolysis(meltingTemp, false, null, null, null);
    }

    public static Pyrolysis evapOn(UnitDouble meltingTemp, UnitDouble vapTemp, UnitDouble heatOfVap, ExSpec vapSpecies) {
        return new Pyrolysis(meltingTemp, true, vapTemp, heatOfVap, vapSpecies);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pyrolysis)) {
            return false;
        }
        Pyrolysis py = (Pyrolysis)obj;
        return this.d_meltingTemp.equals(py.d_meltingTemp) && this.d_evaporate == py.d_evaporate && this.d_vapTemp.equals(py.d_vapTemp) && this.d_heatOfVap.equals(py.d_heatOfVap) && theUtil.equal(this.d_vapSpec, py.d_vapSpec);
    }

    public int hashCode() {
        return 1648883510 + this.d_meltingTemp.hashCode() + theUtil.hashCode(this.d_evaporate) + this.d_vapTemp.hashCode() + this.d_heatOfVap.hashCode() + theUtil.hashCode(this.d_vapSpec);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_evaporate = true;
        in.defaultReadObject();
    }

    public boolean evaporates() {
        return this.d_evaporate;
    }

    public ExSpec getVaporizationSpecies() {
        return this.d_vapSpec;
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, ExSpec.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old != this.d_vapSpec) {
            return EmptyTask.INSTANCE;
        }
        return new AReplaceRefTask<ExSpec>((Object)old, (Object)replacement){

            @Override
            protected void set(ExSpec obj) {
                Pyrolysis.this.d_vapSpec = obj;
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_vapSpec);
    }
}

