/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Isosurface
extends APyroObject
implements IDirectDependent {
    private static final long serialVersionUID = 1L;
    private IQuantity d_measurement;
    private List<UnitDouble> d_contours;
    private VelocitySign d_velocitySign;

    public Isosurface(IQuantity measurement, UnitDouble ... values) {
        this(measurement, Arrays.asList(values));
    }

    public Isosurface(IQuantity measurement, List<UnitDouble> values) {
        this.d_measurement = measurement;
        this.d_contours = values;
        this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.getQuantity().get().mixFracOnly;
    }

    public void setQuantity(IQuantity measurement) {
        this.d_measurement = measurement;
        this.changedEvt(new Object[0]);
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    public void setContours(List<UnitDouble> values) {
        this.d_contours = values;
        this.changedEvt(new Object[0]);
    }

    public List<UnitDouble> getContours() {
        return this.d_contours;
    }

    public VelocitySign getVelocitySign() {
        return this.d_velocitySign;
    }

    public void setVelocitySign(VelocitySign sign) {
        this.d_velocitySign = sign;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Isosurface) {
            Isosurface rec = (Isosurface)obj;
            return this.d_measurement.equals(rec.d_measurement) && this.d_contours.equals(rec.d_contours) && theUtil.equal((Object)this.d_velocitySign, (Object)rec.d_velocitySign);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_velocitySign == null) {
            this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.getQuantity());
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Isosurface.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
            return old.get().unitType == repl.get().unitType && QuantityUtil.canOutputAll(repl.get(), 32);
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    Isosurface.this.setQuantity(obj);
                }
            };
        }
    }
}

