/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public abstract class AMeasurementSet
extends APyroObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private VelocitySign d_velocitySign;

    public AMeasurementSet(IQuantity ... measurements) {
        this.setQuantities(measurements);
        this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
    }

    public VelocitySign getVelocitySign() {
        return this.d_velocitySign;
    }

    public void setVelocitySign(VelocitySign sign) {
        this.d_velocitySign = sign;
        this.changedEvt(new Object[0]);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_velocitySign == null) {
            this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
        }
    }

    public abstract int getOutputType();

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Plot3d)) {
            return false;
        }
        AMeasurementSet p = (AMeasurementSet)o;
        return p.d_measurements.equals(this.d_measurements);
    }

    public void setQuantities(IQuantity ... measurements) {
        this.setQuantities(Arrays.asList(measurements));
    }

    public void setQuantities(Collection<IQuantity> measurements) {
        this.d_measurements.clear();
        this.d_measurements.addAll(measurements);
        this.changedEvt(new Object[0]);
    }

    public Set<IQuantity> getQuantities() {
        return Collections.unmodifiableSet(this.d_measurements);
    }

    @Override
    public boolean isEnabled() {
        return !this.d_measurements.isEmpty();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.WEAK, this.d_measurements);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.d_measurements);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.d_measurements);
    }

    @Override
    public boolean isMixFracOnly() {
        for (IQuantity m : this.d_measurements) {
            if (!m.get().mixFracOnly) continue;
            return true;
        }
        return false;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMeasurementSet.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
            return QuantityUtil.canOutputAll(repl.get(), AMeasurementSet.this.getOutputType());
        }

        @Override
        protected Task taskReplaceQuant(final IQuantity oldMsr, final IQuantity newMsr) {
            return new AUndoableTask(){
                boolean d_added;

                @Override
                public void undo() {
                    if (this.d_added) {
                        AMeasurementSet.this.d_measurements.remove(newMsr);
                    }
                    AMeasurementSet.this.d_measurements.add(oldMsr);
                    AMeasurementSet.this.changedEvt(new Object[0]);
                }

                @Override
                public void run() {
                    AMeasurementSet.this.d_measurements.remove(oldMsr);
                    if (newMsr != null) {
                        this.d_added = AMeasurementSet.this.d_measurements.add(newMsr);
                    }
                    AMeasurementSet.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

