/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.managers;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;

public class Util {
    private static final NumberFormat FMT = new DecimalFormat("###00");

    public static <T extends INamed> void autoRename(Composite<? super T> mgr, T obj) {
        Util.autoRename(mgr, obj, Collections.EMPTY_SET);
    }

    public static <T extends INamed> void autoRename(Composite<? super T> mgr, T obj, Set<String> forbiddenNames) {
        String uniqueName = Util.getUniqueName(mgr, obj, forbiddenNames);
        obj.setName(uniqueName);
    }

    public static <T extends IPyroObject> String getUniqueName(Composite<? super T> mgr, T obj) {
        return Util.getUniqueName(mgr, obj, (Set<String>)Collections.EMPTY_SET);
    }

    public static <T extends IPyroObject> String getUniqueName(Composite<? super T> mgr, T obj, Set<String> forbiddenNames) {
        String baseName = pyrosim.legacy_2012_1.util.Util.getName(obj);
        return Util.getUniqueName(mgr, baseName, forbiddenNames);
    }

    public static <T extends IPyroObject> String getUniqueName(Composite<T> manager, String baseName) {
        return Util.getUniqueName(manager, baseName, false, Collections.EMPTY_SET);
    }

    public static <T extends IPyroObject> String getUniqueName(Composite<T> manager, String baseName, Set<String> forbiddenNames) {
        return Util.getUniqueName(manager, baseName, false, forbiddenNames);
    }

    public static <T extends IPyroObject> String getUniqueName(Composite<T> manager, String baseName, boolean appendOne, Set<String> forbiddenNames) {
        if (!(appendOne || manager != null && manager.get(baseName) != null)) {
            return baseName;
        }
        int number = appendOne ? 1 : 2;
        String name = baseName + FMT.format(number++);
        while (forbiddenNames.contains(name) || manager.get(name) != null) {
            name = baseName + FMT.format(number++);
        }
        return name;
    }
}

