/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class PartCloud
extends AFDSObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private static final int ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.7f, 0.7f, 0.9f, 0.2f);
    private AABoxGeom d_geom;
    private Particle d_particle;
    private IDropletCount d_initDropCount;
    private IInsertion d_insertion;
    private boolean d_isStatic;
    @Deprecated
    private UnitDouble d_density;
    public static final Composite.IObjectProp insertionProp = new Composite.AObjectProp<PartCloud, IInsertion>(PartCloud.class){

        @Override
        public void set(PartCloud obj, IInsertion prop) {
            obj.setInsertion(prop);
        }

        @Override
        public Object get(PartCloud obj) {
            return obj.getInsertion();
        }
    };
    public static final Composite.IObjectProp initDropsProp = new Composite.AObjectProp<PartCloud, IDropletCount>(PartCloud.class){

        @Override
        public void set(PartCloud obj, IDropletCount prop) {
            obj.setInitDrops(prop);
        }

        @Override
        public Object get(PartCloud obj) {
            return obj.getInitDrops();
        }
    };
    public static final Composite.IObjectProp partProp = new Composite.AObjectProp<PartCloud, Particle>(PartCloud.class){

        @Override
        public void set(PartCloud obj, Particle prop) {
            obj.setParticle(prop);
        }

        @Override
        public Object get(PartCloud obj) {
            return obj.getParticle();
        }

        @Override
        public boolean equal(Particle obj1, Particle obj2) {
            return obj1 == obj2;
        }
    };
    public static final Composite.IObjectProp staticProp = new Composite.AObjectProp<PartCloud, Boolean>(PartCloud.class){

        @Override
        public void set(PartCloud obj, Boolean prop) {
            obj.setStatic(prop);
        }

        @Override
        public Object get(PartCloud obj) {
            return obj.isStatic();
        }
    };

    public PartCloud() {
        this(Intl.intl("Particle Cloud"), null, new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN, 0));
    }

    public PartCloud(String description, Particle particle, AABoxGeom geom) {
        super(description);
        this.d_geom = geom;
        this.d_particle = particle;
        this.d_initDropCount = new DropDensityCount();
        this.d_insertion = new InsertOnce();
        this.d_isStatic = false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PartCloud)) {
            return false;
        }
        PartCloud partCloud = (PartCloud)obj;
        return this.d_isStatic == partCloud.isStatic() && this.d_initDropCount.equals(partCloud.getInitDrops()) && this.d_particle.equals(partCloud.getParticle()) && this.d_insertion.equals(partCloud.d_insertion);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_density != null) {
            this.d_insertion = new InsertOnce(this.d_density);
            this.d_density = null;
        }
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public IDropletCount getInitDrops() {
        return this.d_initDropCount;
    }

    public void setInitDrops(IDropletCount numInitDrops) {
        this.d_initDropCount = numInitDrops;
        this.changedEvt(new Object[0]);
    }

    public IInsertion getInsertion() {
        return this.d_insertion;
    }

    public void setInsertion(IInsertion insert) {
        this.d_insertion = insert;
        this.changedEvt(new Object[0]);
    }

    public boolean isStatic() {
        return this.d_isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.d_isStatic = isStatic;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setColors(Color ... c) {
    }

    @Override
    public Color[] getColors() {
        Color color = this.d_particle != null ? this.d_particle.getDescription().getColor() : DEF_COLOR;
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        return new Color[]{color};
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old == this.d_particle) {
            Util.removeAllNotOfType(objs, Particle.class);
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (!(old instanceof Particle)) {
            return super.taskReplaceDep(old, replacement);
        }
        assert (replacement != null);
        return new AReplaceRefTask<Particle>((Object)old, (Object)replacement){

            @Override
            protected void set(Particle obj) {
                PartCloud.this.setParticle(obj);
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        Color[] colors = this.getColors();
        return new DisplayGeom((IGeom)this.getGeom(), (IPrimProps)new IPrimProps.Face(colors[0], null, true));
    }

    @Override
    public AABoxGeom getGeom() {
        return this.d_geom instanceof BlockGeom ? this.d_geom : new BlockGeom(this.d_geom.min, this.d_geom.max, 0);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof AABoxGeom) {
            this.d_geom = (AABoxGeom)geom;
            this.changedEvt(new Object[0]);
        }
    }

    public UnitDouble getVolume() {
        double dx = this.d_geom.max.x - this.d_geom.min.x;
        double dy = this.d_geom.max.y - this.d_geom.min.y;
        double dz = this.d_geom.max.z - this.d_geom.min.z;
        return new UnitDouble(dx * dy * dz, SIUS.unit(56));
    }

    public static class DropDensityCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_density;

        public DropDensityCount() {
            this(SIUS.newud(10.0, 55));
        }

        public DropDensityCount(UnitDouble density) {
            this.d_density = density;
        }

        @Override
        public int getNumDrops(PartCloud cloud) {
            double volume = cloud.getVolume().getValue(SIUS.unit(56));
            double dropDens = this.d_density.getValue(SIUS.unit(55));
            return (int)Math.round(volume * dropDens);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DropDensityCount)) {
                return false;
            }
            DropDensityCount ddc = (DropDensityCount)obj;
            return this.d_density.equals(ddc.d_density);
        }
    }

    public static interface IDropletCount
    extends Serializable {
        public int getNumDrops(PartCloud var1);
    }

    public static class InsertOnce
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble massPerVolume;

        public InsertOnce() {
            this(SIUS.newud(1.0, 4));
        }

        public InsertOnce(UnitDouble massPerVolume) {
            this.massPerVolume = massPerVolume;
        }

        public boolean equals(Object obj) {
            return obj instanceof InsertOnce && theUtil.equal(((InsertOnce)obj).massPerVolume, this.massPerVolume);
        }
    }

    public static interface IInsertion
    extends Serializable {
    }

    public static class InsertPeriodically
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble dt;
        public final UnitDouble massPerTime;

        public InsertPeriodically() {
            this(new UnitDouble(0.01, SI.SECOND), SIUS.newud(1.0, 4));
        }

        public InsertPeriodically(UnitDouble dt, UnitDouble massPerTime) {
            this.dt = dt;
            this.massPerTime = massPerTime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InsertPeriodically)) {
                return false;
            }
            InsertPeriodically insert = (InsertPeriodically)obj;
            return this.dt.equals(insert.dt) && theUtil.equal(this.massPerTime, insert.massPerTime);
        }
    }

    public static class ConstDropletCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final int d_dropCount;

        public ConstDropletCount() {
            this(100);
        }

        public ConstDropletCount(int count) {
            this.d_dropCount = count;
        }

        @Override
        public int getNumDrops(PartCloud cloud) {
            return this.d_dropCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConstDropletCount)) {
                return false;
            }
            ConstDropletCount cdc = (ConstDropletCount)obj;
            return this.d_dropCount == cdc.d_dropCount;
        }
    }
}

