/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class GenericGeomSrc
extends NamedPyroObject
implements IModelObj {
    static final long serialVersionUID = 1L;
    private IGeom d_geom;
    private ITexCoordGenerator d_texGen;
    private IPropsSrc d_props;
    private boolean d_visible;
    public static final Composite.IObjectProp colorProp = new Composite.AObjectProp<GenericGeomSrc, Color[]>(GenericGeomSrc.class){

        @Override
        public void set(GenericGeomSrc obj, Color[] colors) {
            PropsBuilder props = new PropsBuilder();
            int count = obj.getGeom().getNumPrims(7);
            assert (colors.length == 1 || colors.length == count);
            for (int m = 0; m < count; ++m) {
                Color newColor;
                IPrimProps primProp = obj.getDisplayProps().get(m);
                Color color = newColor = colors.length == 1 ? colors[0] : colors[m];
                if (newColor != null) {
                    primProp = new IPrimProps.GenericProps(newColor, primProp.getMaterial(), primProp.getCullFace(), primProp.getEdgeWidth(), primProp.getPointSize());
                }
                props.add(primProp, true);
            }
            obj.setDisplayProps(props.finalizeProps());
        }

        @Override
        public Object get(GenericGeomSrc obj) {
            int count = obj.getGeom().getNumPrims(7);
            Color[] colors = new Color[count];
            for (int m = 0; m < count; ++m) {
                colors[m] = obj.getDisplayProps().get(m).getColor();
            }
            return colors;
        }

        @Override
        public boolean equal(Color[] arg0, Color[] arg1) {
            return Arrays.equals(arg0, arg1);
        }
    };

    public GenericGeomSrc(String name, IGeom geom, IPropsSrc props) {
        this(name, geom, new TexCoordGenerator(new Point3d(0.0, 0.0, 0.0)), props);
    }

    public GenericGeomSrc(String name, IGeom geom, ITexCoordGenerator texGen, IPropsSrc props) {
        super(name);
        this.d_geom = Geometry.finalize(geom, true);
        this.d_texGen = texGen;
        this.d_props = props;
        this.d_visible = true;
    }

    @Override
    public IGeom getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if (this.d_geom == (geom = Geometry.finalize(geom, optimizeGeom))) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    public void setTexCoordGen(ITexCoordGenerator texGen) {
        if (this.d_texGen == texGen) {
            return;
        }
        this.d_texGen = texGen;
        this.changedEvt(new Object[0]);
    }

    public ITexCoordGenerator getTexCoordGen() {
        return this.d_texGen;
    }

    public IPropsSrc getDisplayProps() {
        return this.d_props;
    }

    public void setDisplayProps(IPropsSrc src) {
        this.d_props = src;
        this.changedEvt(new Object[0]);
    }

    @Override
    public AABox getBounds() {
        return this.d_geom.getBoundingBox(new AABox());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom(this.d_geom, this.d_texGen, this.d_props);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        this.d_geom.pickPoints(isects, filter, this, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        if (this.d_geom.intersectsBox(this, filter, box)) {
            result.add(this);
        }
    }

    @Override
    public void getAll(IBoxCollector result, IIsectFilter filter) {
        if (filter.acceptPickObject(this)) {
            result.add(this);
        }
    }
}

