/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.sprayers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.IDeviceModel;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SprayModel
extends NamedPyroObject
implements IDirectDependent,
IDeviceModel {
    static final long serialVersionUID = 1L;
    private Particle d_particle;
    private String d_fyi;
    private UnitDouble d_sprayOffset;
    private FlowRate d_flowRate;
    private List<Jet> d_jets;
    private int d_dropsPerSecond;
    private UnitDouble d_dtInsert;

    public SprayModel(String name, Particle particle) {
        this(name, particle, new UnitDouble(0.05, SI.METER), (FlowRate)new ExplicitFlowRate(), 5000, new UnitDouble(0.01, SI.SECOND), new Jet());
    }

    public SprayModel(String name, Particle particle, UnitDouble sprayOffset, FlowRate flowRate, int dropsPerSecond, UnitDouble dtInsert, Jet ... jets) {
        this(name, particle, sprayOffset, flowRate, dropsPerSecond, dtInsert, Arrays.asList(jets));
    }

    public SprayModel(String name, Particle particle, UnitDouble sprayOffset, FlowRate flowRate, int dropsPerSecond, UnitDouble dtInsert, List<Jet> jets) {
        super(name);
        this.d_sprayOffset = sprayOffset;
        this.d_particle = particle;
        this.d_flowRate = flowRate;
        this.d_dropsPerSecond = dropsPerSecond;
        assert (!jets.isEmpty());
        this.d_jets = jets;
        this.d_dtInsert = dtInsert == null ? new UnitDouble(0.01, SI.SECOND) : dtInsert;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_dtInsert == null) {
            this.d_dtInsert = new UnitDouble(0.01, SI.SECOND);
        }
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getDtInsert() {
        return this.d_dtInsert;
    }

    public void setDtInsert(UnitDouble dtInsert) {
        this.d_dtInsert = dtInsert;
    }

    public int getDropsPerSecond() {
        return this.d_dropsPerSecond;
    }

    public void setDropsPerSecond(int dropsPerSecond) {
        this.d_dropsPerSecond = dropsPerSecond;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return super.equals(obj) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SprayModel)) {
            return false;
        }
        SprayModel desc = (SprayModel)obj;
        return this.d_sprayOffset.equals(desc.d_sprayOffset) && this.d_flowRate.equals(desc.d_flowRate) && this.d_jets.equals(desc.d_jets) && this.d_particle.equals(desc.d_particle);
    }

    public int propHash() {
        return this.d_sprayOffset.hashCode() + this.d_flowRate.hashCode() + this.d_jets.hashCode() + this.d_particle.hashCode();
    }

    public static boolean isParticleValid(Particle part) {
        return part != null && !part.isMassless();
    }

    public static IObjectFilter<Particle> getParticleFilter() {
        return new IObjectFilter<Particle>(){

            @Override
            public boolean shouldFilter(Particle o) {
                return o.isMassless();
            }
        };
    }

    public UnitDouble getSprayOffset() {
        return this.d_sprayOffset;
    }

    public void setSprayOffset(UnitDouble sprayOffset) {
        this.d_sprayOffset = sprayOffset;
        this.changedEvt(new Object[0]);
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        assert (SprayModel.isParticleValid(particle));
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public void setFlowRate(FlowRate rate) {
        this.d_flowRate = rate;
        this.changedEvt(new Object[0]);
    }

    public FlowRate getFlowRate() {
        return this.d_flowRate;
    }

    public List<Jet> getJets() {
        return Collections.unmodifiableList(this.d_jets);
    }

    public void setJets(List<Jet> jets) {
        this.d_jets = jets;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, Particle.class);
        Iterator<T> objit = objs.iterator();
        while (objit.hasNext()) {
            Particle part = (Particle)objit.next();
            if (part == null || SprayModel.isParticleValid(part)) continue;
            objit.remove();
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old != this.getParticle()) {
            return null;
        }
        assert (replacement != null);
        return new AUndoableTask(){

            @Override
            public void undo() {
                SprayModel.this.setParticle((Particle)old);
            }

            @Override
            public void run() {
                SprayModel.this.setParticle((Particle)replacement);
            }
        };
    }

    public static class ExplicitFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_rate;

        public ExplicitFlowRate() {
            this(new TimeBasedValue<UnitDouble>(SIUS.newud(1.0, 30), new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND))));
        }

        public ExplicitFlowRate(TimeBasedValue<UnitDouble> rate) {
            this((UnitDouble)rate.val, rate.func);
        }

        public ExplicitFlowRate(UnitDouble rate, TimeFunction func) {
            super(func);
            this.d_rate = rate;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ExplicitFlowRate)) {
                return false;
            }
            ExplicitFlowRate rate = (ExplicitFlowRate)obj;
            return super.equals(obj) && this.d_rate.equals(rate.d_rate);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.d_rate.hashCode();
        }
    }

    public static class Jet
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_velocity;
        public final UnitDouble d_orificeDiam;
        public final double d_flowFrac;
        public final UnitDouble d_long1;
        public final UnitDouble d_long2;
        public final UnitDouble d_lat1;
        public final UnitDouble d_lat2;

        public Jet() {
            this(SIUS.newud(5.0, 8), null, 1.0, new UnitDouble(60.0, NonSI.DEGREE_ANGLE), new UnitDouble(75.0, NonSI.DEGREE_ANGLE));
        }

        public Jet(UnitDouble velocity, UnitDouble orificeDiam, double flowFrac, UnitDouble lat1, UnitDouble lat2) {
            this(velocity, orificeDiam, flowFrac, new UnitDouble(0.0, NonSI.DEGREE_ANGLE), new UnitDouble(360.0, NonSI.DEGREE_ANGLE), lat1, lat2);
        }

        public Jet(UnitDouble velocity, UnitDouble orificeDiam, double flowFrac, UnitDouble long1, UnitDouble long2, UnitDouble lat1, UnitDouble lat2) {
            this.d_velocity = velocity;
            this.d_orificeDiam = orificeDiam;
            this.d_flowFrac = flowFrac;
            this.d_long1 = long1;
            this.d_long2 = long2;
            this.d_lat1 = lat1;
            this.d_lat2 = lat2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Jet)) {
                return false;
            }
            Jet jet = (Jet)obj;
            return this.d_flowFrac == jet.d_flowFrac && theUtil.equal(this.d_velocity, jet.d_velocity) && theUtil.equal(this.d_orificeDiam, jet.d_orificeDiam) && this.d_long1.equals(jet.d_long1) && this.d_long2.equals(jet.d_long2) && this.d_lat1.equals(jet.d_lat1) && this.d_lat2.equals(jet.d_lat2);
        }

        public int hashCode() {
            return theUtil.hashCode(this.d_flowFrac) + theUtil.hashCode(this.d_velocity) + theUtil.hashCode(this.d_orificeDiam) + this.d_long1.hashCode() + this.d_long2.hashCode() + this.d_lat1.hashCode() + this.d_lat2.hashCode();
        }
    }

    public static abstract class FlowRate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final TimeFunction d_ramp;

        public FlowRate(TimeFunction ramp) {
            this.d_ramp = ramp;
        }

        public boolean equals(Object obj) {
            return obj instanceof FlowRate && this.d_ramp.equals(((FlowRate)obj).d_ramp);
        }

        public int hashCode() {
            return this.d_ramp.hashCode();
        }
    }

    public static class VaryingFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public static final ActiveSprkRamp DEF_RAMP_INPUT = new ActiveSprkRamp();
        public final Ramp d_pressureRamp;
        public final UnitDouble d_opPressure;
        public final UnitDouble d_kFactor;
        public final UnitDouble d_rate;

        public VaryingFlowRate(Ramp pressureRamp, UnitDouble opPressure, UnitDouble kFactor, UnitDouble rate, TimeFunction ramp) {
            super(ramp);
            this.d_opPressure = opPressure;
            this.d_kFactor = kFactor;
            this.d_rate = rate;
            this.d_pressureRamp = pressureRamp;
            assert (this.isValid());
        }

        public boolean isValid() {
            if (this.d_pressureRamp.getTUnitType() != 28 || this.d_pressureRamp.getFUnitType() != 39) {
                return false;
            }
            int numSpec = 0;
            if (this.d_opPressure != null) {
                ++numSpec;
            }
            if (this.d_kFactor != null) {
                ++numSpec;
            }
            if (this.d_rate != null) {
                ++numSpec;
            }
            return numSpec >= 2;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof VaryingFlowRate)) {
                return false;
            }
            VaryingFlowRate rate = (VaryingFlowRate)obj;
            return super.equals(obj) && theUtil.equal(this.d_opPressure, rate.d_opPressure) && theUtil.equal(this.d_kFactor, rate.d_kFactor) && theUtil.equal(this.d_rate, rate.d_rate) && this.d_ramp.equals(rate.d_ramp);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + theUtil.hashCode(this.d_opPressure) + theUtil.hashCode(this.d_kFactor) + theUtil.hashCode(this.d_rate) + this.d_ramp.hashCode();
        }

        private static class ActiveSprkRamp
        implements IRampInput {
            static final long serialVersionUID = 1L;

            private ActiveSprkRamp() {
            }

            @Override
            public String getName() {
                return Intl.intl("Num Active Sprinklers/Nozzles");
            }

            @Override
            public int getUnitType() {
                return 28;
            }

            private Object readResolve() throws ObjectStreamException {
                return DEF_RAMP_INPUT;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        }
    }

    public static class PressurizedFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_opPressure;
        public final UnitDouble d_kFactor;

        public PressurizedFlowRate() {
            this(SIUS.newud(1.0, 59), SIUS.newud(1.0, 58), new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND)));
        }

        public PressurizedFlowRate(UnitDouble opPressure, UnitDouble kFactor, TimeFunction ramp) {
            super(ramp);
            this.d_opPressure = opPressure;
            this.d_kFactor = kFactor;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PressurizedFlowRate)) {
                return false;
            }
            PressurizedFlowRate rate = (PressurizedFlowRate)obj;
            return super.equals(obj) && this.d_opPressure.equals(rate.d_opPressure) && this.d_kFactor.equals(rate.d_kFactor);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.d_opPressure.hashCode() + this.d_kFactor.hashCode();
        }
    }
}

