/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.awt.Color;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.domain.devices.AttachedPointGeom;
import pyrosim.legacy_2012_1.domain.devices.IAttachedPointDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class SolidPointMeasurer
extends AMeasuringDevc
implements IAttachedPointDevice {
    static final long serialVersionUID = 1L;
    private AttachedPointLoc d_loc;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(new Color(0.7f, 0.7f, 0.0f), 10.0);
    private static final IGeom s_baseGeom = new Point(new Point3d(0.0, 0.0, 0.0));

    public SolidPointMeasurer(String name, IQuantity measurment, AttachedPointLoc loc) {
        super(name, measurment);
        this.d_loc = loc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SolidPointMeasurer && super.equals(obj) && this.d_loc.equals(((SolidPointMeasurer)obj).d_loc);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_loc.toFreePoint();
    }

    @Override
    public AttachedPointLoc getAttachedLocation() {
        return this.d_loc;
    }

    @Override
    public void setLocation(AttachedPointLoc loc) {
        this.d_loc = loc;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.SOLID;
    }

    public static int getOutputType() {
        return 1;
    }

    public static IObjectFilter<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(SolidPointMeasurer.getOutputType(), SolidPointMeasurer.getQuantityType());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeom getGeom() {
        return new AttachedPointGeom(this.d_loc, s_baseGeom);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof AttachedPointGeom) {
            AttachedPointGeom p = (AttachedPointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point) {
            this.setLocation(this.d_loc.setLoc(((Point)geom).loc));
        }
    }
}

