/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.Filters;

public class SolidDensityMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_depth;

    public SolidDensityMeasurer(String name, ObjectQuantity<Material> measurement, AttachedPointLoc loc) {
        this(name, measurement, new UnitDouble(0.0, SI.METER), loc);
    }

    public SolidDensityMeasurer(String name, ObjectQuantity<Material> measurement, UnitDouble depth, AttachedPointLoc loc) {
        super(name, measurement, loc);
        this.d_depth = depth;
        assert (measurement.get() == Quantity.MATL_SOLID_DENSITY);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SolidDensityMeasurer && super.equals(obj) && this.d_depth.equals(((SolidDensityMeasurer)obj).d_depth);
    }

    public static IObjectFilter<Quantity> getQuantityFilter() {
        return Filters.acceptOnly(Quantity.MATL_SOLID_DENSITY);
    }

    public UnitDouble getDepth() {
        return this.d_depth;
    }

    public void setDepth(UnitDouble depth) {
        this.d_depth = depth;
        this.changedEvt(new Object[0]);
    }
}

