/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.awt.Color;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.domain.devices.FreePointGeom;
import pyrosim.legacy_2012_1.domain.devices.IFreePointDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class GasPointMeasurer
extends AMeasuringDevc
implements IFreePointDevice {
    static final long serialVersionUID = 1L;
    private FreePointLoc d_location;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(new Color(0.7f, 0.7f, 0.0f), 10.0);
    private static final IGeom s_baseGeom = new Point(new Point3d(0.0, 0.0, 0.0));

    public GasPointMeasurer(String name, IQuantity measurement, FreePointLoc loc) {
        super(name, measurement);
        this.d_location = loc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GasPointMeasurer && super.equals(obj) && this.d_location.equals(((GasPointMeasurer)obj).d_location);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc loc) {
        this.d_location = loc;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.GAS;
    }

    public static int getOutputType() {
        return 1;
    }

    public static IObjectFilter<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeom getGeom() {
        return new FreePointGeom(this.d_location, s_baseGeom);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof FreePointGeom) {
            FreePointGeom p = (FreePointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point) {
            this.setLocation(this.d_location.setLoc(((Point)geom).loc));
        }
    }
}

