/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.devices.IDeviceModel;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class SprinklerLinkModel
extends NamedPyroObject
implements IDeviceModel {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_rti;
    private UnitDouble d_activationTemp;
    private UnitDouble d_initTemp;
    private UnitDouble d_cFactor;

    public SprinklerLinkModel(String name) {
        this(name, new UnitDouble(100.0, SIUS.getInstance().getRtiUnit()), null, new UnitDouble(74.0, SI.CELSIUS), SIUS.newud(0.0, 60));
    }

    public SprinklerLinkModel(String name, UnitDouble rti, UnitDouble initTemp, UnitDouble activationTemp, UnitDouble cFactor) {
        super(name);
        this.d_rti = rti;
        this.d_activationTemp = activationTemp;
        this.d_initTemp = initTemp;
        this.d_cFactor = cFactor;
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return super.equals(obj) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SprinklerLinkModel)) {
            return false;
        }
        SprinklerLinkModel desc = (SprinklerLinkModel)obj;
        return this.d_cFactor.equals(desc.d_cFactor) && this.d_rti.equals(desc.d_rti) && this.d_activationTemp.equals(desc.d_activationTemp) && theUtil.equal(this.d_initTemp, desc.d_initTemp);
    }

    public int propHash() {
        return this.d_cFactor.hashCode() + this.d_rti.hashCode() + this.d_activationTemp.hashCode() + theUtil.hashCode(this.d_initTemp);
    }

    public UnitDouble getRti() {
        return this.d_rti;
    }

    public void setRti(UnitDouble rti) {
        this.d_rti = rti;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getInitialTemp() {
        return this.d_initTemp;
    }

    public void setInitialTemp(UnitDouble initTemp) {
        this.d_initTemp = initTemp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getActivationTemp() {
        return this.d_activationTemp;
    }

    public void setActivationTemp(UnitDouble actTemp) {
        this.d_activationTemp = actTemp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getCFactor() {
        return this.d_cFactor;
    }

    public void setCFactor(UnitDouble cFactor) {
        this.d_cFactor = cFactor;
        this.changedEvt(new Object[0]);
    }
}

